USE hahn;

$TOTAL_VALUE = '__total__';
$DAY_OFFSET = 3;


$platform_check = ($platform) -> {
    RETURN $platform == $TOTAL_VALUE 
        OR $platform IN ('android', 'iOS');
};
$region_check = ($region) -> {
    RETURN $region == $TOTAL_VALUE 
        OR CAST($region as Int32) IS NOT NULL;
};

$discardEnsure = ($check, $msg) -> {
    RETURN Ensure(0, $check, $msg);
};

$tableFolder = ($path) -> {
    RETURN String::ReplaceAll($path, '/' || TableName($path), '');
};


DEFINE ACTION $post_report($data, $path, $date, $validate) AS
    $start_date = $date;
    $end_date = $date + DateTime::IntervalFromDays($DAY_OFFSET);
    
    $recalculate_report = (
        SELECT
            *
        FROM
            $path
        WHERE
            CAST(fielddate as Date) != $date
        UNION ALL
        SELECT
            *
        FROM
            $data($start_date, $end_date)
        WHERE
            CAST(fielddate as Date) == $date
    );
    
    $new_report = (
        SELECT
            *
        FROM
            $data($start_date, $end_date)
        WHERE
            CAST(fielddate as Date) == $date
    );
    
    $table_siblings_list = (
        SELECT 
            AGGREGATE_LIST(TableName(Path))
        FROM FOLDER($tableFolder($path))
        WHERE
            Type = "table"
    );
    
    EVALUATE IF ListHas($table_siblings_list, TableName($path)) DO BEGIN
        INSERT INTO @tmp
        SELECT
            *
        FROM
            $path
        WHERE
            CAST(fielddate as Date) != $date
    END DO;
    
    INSERT INTO @tmp
    SELECT
        *
    FROM
        $data($start_date, $end_date)
    WHERE
        CAST(fielddate as Date) == $date;
        
    EVALUATE IF $validate DO BEGIN
        -- region check --
        DISCARD SELECT $discardEnsure(
            $region_check(region),
            "Expected region id"
        ) FROM @tmp;
        
        -- platform check --
        DISCARD SELECT $discardEnsure(
            $platform_check(platform),
            "Unknown platform type"
        ) FROM @tmp;
    END DO;
    
    COMMIT;
    
    INSERT INTO $path WITH TRUNCATE
    SELECT
        *
    FROM
        @tmp;
END DEFINE;

EXPORT
    $discardEnsure,
    $region_check,
    $platform_check,
    $post_report,
    $TOTAL_VALUE;