$companies_names = AsDict(
AsTuple("3aa64a7bba794c2f8e8891398c10e3b5","Башнефть-Розница, ООО"),
AsTuple("771ee3460da84c12b51b8bca5da62468","Воронежнефтепродукт, ООО"),
AsTuple("59a004226c1a453789e343eac5a7d034","НК «Роснефть» - Кубаньнефтепродукт, ПАО"),
AsTuple("090f635906bc48738468deb59a52246c","ПТK, ООО"),
AsTuple("bc23d0db1dd44e7e977b14228c6c78c6","РН-Волгоград, ООО"),
AsTuple("bc04a795d67b4a4d8d0e00cc491405b6","РН-Карт, ООО"),
AsTuple("80c17d364c5a46d2ae09428ea6042536","РН-Красноярскнефтепродукт, ООО"),
AsTuple("27c3eb536be546db96e1834d25995b22","РН-Москва, АО"),
AsTuple("07ca310f4d4745eda85d50c7be48ab26","РН-Новосибирскнефтепродукт, ООО"),
AsTuple("55d28df8df7449c181ece44164d440b4","РН-Ростовнефтепродукт, ООО"),
AsTuple("b16608f2a48b459fbca8dc50b290cd95","РН-Северо-Запад, ООО"),
AsTuple("b2f9d1385415436c8a8098f5d44c4384","РН-Тверь, АО"),
AsTuple("cdeedbafe1a246039dea82715aa842ad","Самаранефтепродукт, АО"),
AsTuple("24ce9194e84742f49cdf6040a10649e6", "Рязаньнефтепродукт, АО"),
AsTuple("5172794656a348e98a1d9039357126b8", "РН-Черноземье, ООО"),
AsTuple("84875a5bcb094f16ac85d699dcc570ff", "Брянскнефтепродукт, АО"),
AsTuple("a5932622655a4078a52b1a1d7b74a776", "Калуганефтеподукт, АО"),
AsTuple("d38719e7f4f2493aa9e0675ecba04082", "Туланефтепродукт, ПАО"),
AsTuple("df205cb4303e45e4894a480856cc5bf8", "РН-Ярославль, АО"),
AsTuple("e058c62a05644fcc8344e5fce120ff4e", "Саратовнефтепродукт, ПАО"),
AsTuple("e2198bb51dcf4e2db046d834c7dd552a", "Липецкнефтепродукт, АО"),
AsTuple("f25f92c3de1b4b1aaf70c2b41593f349", "РН-Карт, ООО (вирт)"),
AsTuple("085735f018a44d75b8beb3eac757a5cc", "Пензанефтепродукт, АО"),
AsTuple("total", "Все"),
);

$RN_network_id = 'c62b6f4991cd4bd28408121d0aad34ef';

$today = CAST(CurrentUtcDate() AS String);
$date_format = DateTime::Format("%Y-%m-%d");
$date_parse = DateTime::Parse("%Y-%m-%d");
$round_period = ($date, $scale) -> {
    RETURN CASE $scale 
        WHEN "d" THEN DateTime::StartOfDay($date)
        WHEN "w" THEN DateTime::StartOfWeek($date)
        WHEN "m" THEN DateTime::StartOfMonth($date)
        WHEN "q" THEN DateTime::StartOfQuarter($date)
        WHEN "y" THEN DateTime::StartOfYear($date)
        ELSE $date
    END;
};
$round_period_str = ($date, $scale) -> {
    RETURN $date_format($round_period($date, $scale));
};


$orders_table = '//home/zapravki/production/replica/mongo/struct/orders_full';


EXPORT 
    $RN_network_id,
    $companies_names,
    $today,
    $date_format,
    $date_parse,
    $round_period,
    $round_period_str,
    $orders_table
