$cities_rk_202008 = AsSet(35, 39, 41, 43, 45, 51, 56, 62, 64, 66, 172, 193, 236, 240, 11121, 11127);
$big_networks_ids = AsSet(  'c62b6f4991cd4bd28408121d0aad34ef', --РОСНЕФТЬ
                            '4d63651000084b8da2fbaf3cefe88d81', --Benzuber
                            '7ddf2e1b443c4f529862357574af260c', --Нефтьмагистраль
                            '866343ef8a2b4a57a5767c7bd99ab418', --Shell
                            '52362dbae50345c1a27329d8663f6011', --ЕКА
                            '3c0f8851b7134b91a0268745e38089a1', --Татнефть
                            '257c446a207945ae80308f0dfe762e69' ); -- ТРАССА networks dict //home/zapravki/production/stations_stat/dashboard/networks_dict
$big_apps = AsSet('Таксометр', 'Навигатор', 'Заправки', 'Яндекс.Карты', 'Турбоапп'); -- big apps dict //home/zapravki/production/stations_stat/dashboard/apps_dict

$GetRegionName = ($region_id) -> {
    return CASE
        WHEN $region_id = -1 THEN "Не Москва"
        ELSE Geo::RegionById($region_id).name
    END 
};



$GetRegionsListById = ($geo_id) -> {
    $region_id = Geo::RoundRegionById($geo_id, 'region').id ?? 0;
    return 
        CASE
            WHEN $region_id = 1 
            THEN
                AsList(10000, 1)
            ELSE 
                if(
                    $region_id in (0, 10000), 
                    AsList(10000, -1),
                    AsList(10000, $region_id, -1,)
                )
        END
};

$GetRegionsList = ($lat, $lon) -> {
    $geo_id = Geo::RegionByLocation($lat, $lon).id;
    return $GetRegionsListById($geo_id);
};

$GetNetworkIdList = ($NetworkId) -> {
    return 
        CASE
            WHEN $NetworkId in $big_networks_ids
                THEN 
                    AsList('_total_', $NetworkId)
            ELSE 
                AsList('_total_', '_small_networks_', $NetworkId)
        END
};

$GetNetworkNameById = ($NetworkId) -> {
    return 
        CASE
            WHEN $NetworkId = '_total_'
                THEN 'Все'
            WHEN $NetworkId = 'small_networks'
                THEN 'Остальные'
            ELSE 
                IdToName($NetworkId)--!!!!!!!!!!!
        END
};

$GetAppsList = ($Application) -> {

    return if($Application in $big_apps, AsList('Все', $Application), AsList('Все', $Application, 'Остальные'))

};

$GetOSList = ($Version) -> {
    return case 
        when $Version ILIKE '%android%' THEN AsList('Android', 'Все')
        when $Version ILIKE '%ios%' THEN AsList('iOS', 'Все')
    else AsList('Все')
    end
};

$GetContractType = ($corp_id) -> {
    return AsList(
        if( 
            $corp_id is null, 
            'individual',
            'corporation'
            ),     
        'total'
        )
};

EXPORT 
    $big_networks_ids,
    $big_apps, 
    $GetRegionName,
    $GetRegionsListById, 
    $GetRegionsList, 
    $GetNetworkIdList, 
    $GetAppsList, 
    $GetOSList,
    $GetContractType
