# -*- coding: utf-8 -*-

import sys
import imaplib
import email
import os
import re
import argparse

from tarfile import TarInfo, TarFile
from io import BytesIO


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--host', help='Host')
    parser.add_argument('--login', help='Login')
    parser.add_argument('--password', help='Password')
    parser.add_argument('--folder', help='Folder')
    parser.add_argument('--search', help='Mail search string')
    parser.add_argument('--filename_regexp', help='Filename regexp')

    args = parser.parse_args()

    password = args.password or os.environ['IMAP_PASSWORD']

    mail = imaplib.IMAP4_SSL(args.host)
    mail.login(args.login, password)

    status, _ = mail.select(args.folder)
    assert status == 'OK'

    _, data = mail.uid('search', None, args.search)

    tario = BytesIO()
    tar = TarFile.open(fileobj=tario, mode='w')

    uids = data[0].split()
    uids.reverse()

    for uid in uids:
        _, data = mail.uid('fetch', uid, '(RFC822)')
        raw_email = data[0][1]

        email_message = email.message_from_bytes(raw_email)

        for part in email_message.walk():

            filename = part.get_filename()
            if filename:
                filename, encoding = email.header.decode_header(filename)[0]

                if encoding:
                    filename = str(filename, encoding)

                if re.match(args.filename_regexp, filename):
                    buf = BytesIO(part.get_payload(decode=True))

                    info = TarInfo(name=filename)
                    info.size = len(buf.getbuffer())
                    tar.addfile(tarinfo=info, fileobj=buf)

    tar.close()
    mail.logout()

    sys.stdout.buffer.write(tario.getbuffer())

if __name__ == '__main__':
    main()
