# -*- coding: utf-8 -*-

import sys
import pandas as pd

from io import BytesIO, StringIO
from tarfile import TarFile


def xlsx_to_tsv(data):
    # data = sys.stdin.buffer.read()

    data_str_in = BytesIO(data)
    df = pd.read_excel(data_str_in, engine='xlrd')

    data_str_out = StringIO()
    df.to_csv(data_str_out, sep='\t', index=False, header=None, encoding='utf-8')

    ret = data_str_out.getvalue()

    data_str_in.close()
    data_str_out.close()

    return ret


def processed_tsv(data):
    lines = data.split('\n')

    table = []
    for line in lines:
        prep_line = line.split('\t')[1:]
        if len(prep_line) < 1 or prep_line[0] == '':
            continue

        table.append(prep_line)

    header = table[0]

    tsv = ''
    for row in table[1:]:
        phone = row[0]

        if phone == 'ИТОГО':
            continue

        for i, col in enumerate(row[1:-1]):
            date = header[i+1]
            cost = '0' if col == '' else col

            tsv += '\t'.join((
                phone,
                date,
                cost,
            )) + '\n'

    return tsv


def main():
    data = sys.stdin.buffer.read()  # .decode('utf-8')

    tario = BytesIO(data)
    tar = TarFile.open(fileobj=tario, mode='r')

    tsv = 'phone\tdate\tcost\n'
    for file_name in tar.getnames():
        fileobj = tar.extractfile(file_name).read()
        tsv_file = xlsx_to_tsv(fileobj)
        tsv += processed_tsv(tsv_file)

    sys.stdout.write(tsv)

if __name__ == '__main__':
    main()
