#!/usr/bin/python3
"""
Скачивает граф с yt

Для скачивания графа с ecstatic (быстрее, но нет старых версий)
https://a.yandex-team.ru/arc/trunk/arcadia/maps/tools/graph_downloader/graph_downloader.py
"""

import os
import sys
import argparse

files_sets = {
    'min': """data.mms.2
                edges_persistent_index.mms.1
                edges_rtree.mms.2
                topology.mms.2""".split(),

    'min_road': """data.mms.2
                edges_persistent_index.mms.1
                edges_rtree.mms.2
                topology.mms.2
                road_graph.fb""".split(),

    'router': """carparks.mms.1 l6a_topology.fb.7 rtree.fb
            edges_persistent_index.fb l6a_truck_diff.fb segments_rtree.mms.2
            l6a_data.fb.7 road_graph.fb
            l6a_experimental_speeds_diff.fb routing_barriers_rtree.mms.1""".split(),
}


def main():
    command_arguments = argparse.ArgumentParser(description='Downloads graph from yt to current folder')
    command_arguments.add_argument('version', help='graph version (choose from //home/maps/graph/ )')
    command_arguments.add_argument('--set', choices=list(files_sets.keys()), default='min_road', help='choose file set')
#     command_arguments.add_argument('--files', help='which')
    args = command_arguments.parse_args()
    version = args.version
    try:
        os.mkdir(version)
    except FileExistsError:
        pass
    for filename in files_sets[args.set]:
        # pv -l >
        assert not os.system(
            'yt download "//home/maps/graph/{version}/{file}" --proxy hahn > "{version}/{file}"'
            .format(version=version, file=filename)
        )
    print('Now run:\nsudo mv {version} /var/spool/yandex/maps/graph/'
          .format(version=version))

if __name__ == '__main__':
    main()
