# -*- coding: UTF-8 -*-
"""Считаем статистику графа"""

from __future__ import print_function


import argparse
import collections
import yt.wrapper as yt

from analytics.geo.tools.graph.lib.edges import EdgeData


def main():
#     this_path = os.path.dirname(os.path.realpath(__file__))

    command_arguments = argparse.ArgumentParser(description='calc graph stat')
    command_arguments.add_argument('--bbox', "-b", nargs=4, type=float, required=True, help="lat0 lon0 lat1 lon1")
    command_arguments.add_argument('--output', "-o", help="file to save results")
    args = command_arguments.parse_args()

    edges_data = EdgeData()
    stat = collections.defaultdict(float)
    bbox = [args.bbox[:2], args.bbox[2:]]
    edges = edges_data.get_edges_in_bounds(bbox)
    edge_is_none = 0
    print('edges found', len(edges))
    selected_list = []
    for edge in edges:
#         print(edge)
        if edge is None:
            edge_is_none += 1
            continue
        try:
            ed = edges_data.get_edge_data(edge)
        except:
            print(edge)
            raise
#         print(dir(ed))
#         break
#         if ed.speed_limit <= 61/3.6:
#             continue
#         if ed.category != 2:
#             continue
#         print(ed.category, ed.length)
        stat[ed.category] += ed.length
#         selected_list.append(edge)
#         break
    print(stat)
#     if args.output:
#         with open(args.output, 'w') as wf:
#             wf.write('pid\n')
#             for v in selected_list:
#                 wf.write('{}\n'.format(v))
    if args.output:
        with open(args.output, 'w') as wf:
            wf.write('category;meters\n')
            for k, v in stat.items():
                wf.write('{};{}\n'.format(k, v))

if __name__ == "__main__":
    main()
