"""
Документация Мойры
https://github.yandex-team.ru/maps/moira-int/blob/master/docs/v1/spec.yaml
"""

import json
import requests
from tvm2 import TVM2
from tvmauth import BlackboxTvmId

MOIRA_URLS = {
    'prod': 'https://moira-int.c.maps.yandex.net',
    'tst': 'https://moira-int.tst.c.maps.yandex.net',
}

class TVMClient:
    def __init__(self, params):
        # assert bool(work_mode) != bool(tvm_params)
        # if tvm_params:
        #     params = tvm_params
        # else:
        #     filename = f'tvm_params_{work_mode}.json'
        #     with open(filename) as rf:
        #         params = json.load(rf)
        self.tvm = TVM2(
            client_id=str(params['client']),
            secret=params['client_secret'],
            blackbox_client=BlackboxTvmId.Prod,
            allowed_clients=(params['client'], ),
            destinations=(params['destination'], ),
        )
        self.destination = str(params['destination'])
        self.description = f"client {params['client']} - destination {params['destination']}"

    def get_ticket(self):
        return self.tvm.get_service_tickets(self.destination)[self.destination]


class MoiraClient:
    def __init__(self, moira_mode, project, tvm_params):
        self.moira_mode = moira_mode
        self.project = project
        self.moira_url = MOIRA_URLS[moira_mode]
        self.tvm = TVMClient(tvm_params)

    def read_all(self):
        limit = 1000
        offset = 0
        all_entries = {}

        while True:
            response = requests.get(
                f'{self.moira_url}/v1/projects/{self.project}?limit={limit}&offset={offset}',
                headers={'X-Ya-Service-Ticket': self.tvm.get_ticket()},
            )
            assert response.status_code == 200, (response, response.text)

            answer = response.json()
            entries = answer['entries']
            if not entries:
                break

            # if with_uuids:
            #     all_entries.update({e['key']: e['value'] for e in entries
            #                         if 'uuid' in e['value'] and e['key'] == e['value']['uuid']})
            # else:
            all_entries.update({e['key']: e['value'] for e in entries})
    #         print(answer)
    #         print(answer)
    #         break
            offset += len(entries)  # limit
        return all_entries

    def iterate_all(self, verbose=False):
        # yield {'40406cf9587a3f3110c96e24bc34fe28':
        #     {
        #         "created": 1617526700,
        #         "attempts": [
        #             {
        #                 "created": 1617526800,
        #             }
        #         ]
        #     }
        # }
        # yield {'0007bd859bbe4cd787a3bd2d9d2eefc7':
        #     {
        #         "created": 1617526700,
        #         "attempts": [
        #             {
        #                 "created": 1617542272,
        #             }
        #         ]
        #     }
        # }

        limit = 1000
        offset = 0

        try:
            while True:
                if verbose:
                    print('Moira request', offset, limit)
                response = requests.get(
                    f'{self.moira_url}/v1/projects/{self.project}?limit={limit}&offset={offset}',
                    headers={'X-Ya-Service-Ticket': self.tvm.get_ticket()},
                )
                assert response.status_code == 200, (response, response.text, limit, offset)

                answer = response.json()
                if verbose == 2:
                    print(answer)
                entries = answer['entries']
                if not entries:
                    break

                for e in entries:
                    # print(e)
                    yield {e['key']: e['value']}

                offset += len(entries)
                # if offset > 1000:
                #     print('HUCK HERE!!!! Stop Moira at', offset)
                #     break
        except Exception as e:
            print(f'iterate_all Exception. {e} TVM params: {self.tvm.description}')
            raise

    def update_key(self, key, update, apply_diff=True, retry=4):
        apply_diff_str = '?apply_diff=1' if apply_diff else ''
        url = f'{self.moira_url}/v1/projects/{self.project}/entries/{key}{apply_diff_str}'
    #     print(url)

        for num_of_try in range(retry+1):
            try:
                answer = requests.put(
                        url,
                        json={'value': update},
                        headers={'X-Ya-Service-Ticket': self.tvm.get_ticket()},
                   )
            except Exception as e:
                if num_of_try >= retry:
                    raise
                print(f'update_key_in_moira failed: {e}. Will retry after pause...')
                time.sleep(2**num_of_try)
                continue
            if answer.status_code != 200:
                if answer.status_code == 404:
                    print(f'update_key_in_moira failed with 404 at {key}')
                    return answer.status_code
                if num_of_try < retry:
                    print(f'update_key_in_moira answer code is {answer.status_code}. Will retry after pause...')
                    time.sleep(2**num_of_try)
                    continue
            break
        assert answer.status_code == 200, (answer, answer.text)
        return answer.status_code


    # def add_key_in_moira(moira_url, tvm, key, data):
    # #      https://moira-int.tst.c.maps.yandex.net/v1/projects/toyota/entries/{key}
    #     answer = requests.post(
    #             f'{moira_url}/v1/projects/toyota/entries/{key}',
    #             json={'value': data},
    #             headers={'X-Ya-Service-Ticket': tvm.get_ticket()},
    #        )
    # #     print(answer)
    # #     print(answer.text)
    #     assert answer.status_code == 200, (answer, answer.text)
    # #     print(answer.json())
