"""
Отправляет сообщение через телеграм-бота, используя напрямую API телеграма
"""

import os
import requests


def write_to_telegram(text, chat_id, **args):
    if args.get('token'):
        token = args['token']
    else:
        token_file = args.get("token_file")
        if not token_file:
            token_file = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                                      'telegram_token.txt')
        with open(token_file) as rf:
            token = rf.readline().strip()
    assert token

    chat_id = int(chat_id)

    try:
        params = {'chat_id': chat_id, 'text': text}
        if args.get('disable_notification'):
            params['disable_notification'] = True
        if args.get('markdown_text'):
            params['parse_mode'] = "Markdown"
        if args.get('disable_web_page_preview'):
            params['disable_web_page_preview'] = True
        ret = requests.post(f'https://api.telegram.org/bot{token}/sendMessage',
                            params)
        if not ret.json()["ok"]:
            print("telegram send error response", ret.text)
    #         print("write_to_telegram", ret, params)
    except Exception as e:
        print("write_to_telegram Exception", e)
        return e


def echo_to_telegram(**args):
    if args.get('token'):
        token = args['token']
    else:
        token_file = args.get("token_file")
        if not token_file:
            token_file = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                                      'telegram_token.txt')
        with open(token_file) as rf:
            token = rf.readline().strip()
    assert token

    url = 'https://api.telegram.org/bot%s/getUpdates?offset=%d' % (
        token,
        0)
    res = requests.get(url).json()
    # print('tg api res:', res)
    if not res.get("ok") is True:
        print("Telegram read_message is not ok", res)
        raise IOError()
    for result in res["result"]:
        try:
            chat_id = result["message"]["chat"]["id"]
        except Exception as e:
            try:
                print("echo_to_telegram exception", e, "from result:\n", result)
            except:
                print("echo_to_telegram exception", e)
            continue
        write_to_telegram("Our chat id %d" % chat_id,
                          chat_id,
                          disable_notification=True)
