"""
Глобальный лок с помощью таблицы yt
"""

class LockNode:
    def __init__(self, yt, node, timeout=4*3600*1000, verbose=False):
        """
        :param yt: Передаём yt
        :param node: Адрес запираемой таблицы (если не существует, то будет создана)
        :param timeout: Время в миллисекундах (!) через которое lock автоматически снимется
        :param verbose: Печатать текст о том, что сделал или нет.
        """
        self.node = node
        self.yt = yt
        self.locked = False
        if node is None:
            if verbose:
                print("Lock isn't used as node is None")
            return

        transaction = yt.config.COMMAND_PARAMS["transaction_id"]
        self.yt_transaction_lock = yt.start_transaction(timeout=timeout)
        yt.config.COMMAND_PARAMS["transaction_id"] = self.yt_transaction_lock
        if not yt.exists(self.node):
            yt.create('table', self.node)
        yt.lock(self.node)
        self.locked = True
        yt.config.COMMAND_PARAMS["transaction_id"] = transaction
        if verbose:
            print('Lock is taken', self.yt_transaction_lock, node)

    def unlock(self):
        if not self.locked:
            return
        self.yt.abort_transaction(self.yt_transaction_lock)
        self.locked = False

    def __del__(self):
        self.unlock()
