# -*- coding: UTF-8 -*-
from __future__ import print_function


def extend_clids(clids_list, missing='warn'):
    """
    Return list of clids with extended abbrevition like 'navi' or 'ymaps',
    It also supports 'all' which must be the only param and it returns None
        to show no clids list, just any clid is OK
    :param clids_list:
    :param missing:
    :return:
    """
    clids_dict = {
        'navi': ['ru.yandex.mobile.navigator', 'ru.yandex.yandexnavi'],
        'ymaps': ['ru.yandex.traffic', 'ru.yandex.yandexmaps'],
        'taxi': ['ru.yandex.taximeter'],
    }
    clids_dict['cars'] = clids_dict['navi'] + clids_dict['ymaps'] + clids_dict['taxi'] + ['auto', 'yandex.auto']

    if len(clids_list) == 1 and clids_list[0] == 'all':
        return None
    assert 'all' not in clids_list

    result = []
    for clid in clids_list:
        if clid in clids_dict:
            result += clids_dict[clid]
        else:
            if missing == 'warn':
                print('Unknown clid', clid)
            elif missing == 'ignore':
                pass
            else:
                raise ValueError('Unknown clid', clid)
            result.append(clid)

    return result
