#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne
)
from qb2.api.v1 import (
    QB2,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import datetime


def time_from_object_id(o_str):
    id_time = int(o_str[0:8], 16)
    return str(datetime.datetime.fromtimestamp(id_time).date())

@with_hints(
    output_schema=dict(
        cardId=str,
        is_private=bool
    )
)
def myMap(recs):
    for rec in recs:
        cardId = rec.id
        document = rec.document
        is_private = bool(document["is_private"])
        yield Record(cardId=cardId, is_private=is_private)

@with_hints(
    output_schema=dict(
        path=str,
        cardId=str,
        owner=str,
        source_type=str,
        doc_id=str,
        is_private=bool,
        fielddate=str
    )
)
def myMap_card(recs):
    for rec in recs:
        cardId = rec.id
        owner = rec.owner
        document = rec.document
        try:
            if "ban" in document:
                if document["ban"] is True or document["ban"]=="y":
                    continue

            is_private, source_type, doc_id  = False, None, None
            service = document["service"]
            if "is_private" in document:
                is_private = bool(document["is_private"])
            if "created_at" in service:
                created_at = service["created_at"]["_$date"]
                date = created_at[:10]
            if "source_type" in document["content"][0]:
                source_type = document["content"][0]["source_type"]
            if "doc_id" in document:
                doc_id = document["doc_id"]
            if date != "":
                fielddate = date
                yield Record(path="finish.card.create", cardId=cardId, board_id=rec.board, owner=owner, is_private=is_private, source_type=source_type, doc_id=doc_id, fielddate=fielddate)
        except:
            continue

@with_hints(
    output_schema=dict(
        path=str,
        comment=str,
        owner=str,
        updtd=bool,
        is_private=bool,
        fielddate=str
    )
)
def myMap_comment(recs):
    for rec in recs:
        comment = rec.id
        document = rec.document
        owner = None
        if "owner" in document:
            owner = document["owner"]["_$oid"]
        is_private = bool(document["is_private"])
        fielddate = ""
        service = document["service"]
        if not "card" in document:
            continue
        cardId = document["card"]["_$oid"]
        if "created_at" in service:
            created_at = service["created_at"]["_$date"]
            updated_at = service["updated_at"]["_$date"]
            updtd = bool(created_at != updated_at)
            date = created_at[:10]
        if date != "":
            fielddate = date
            yield Record(path="finish.card.comment", comment=comment, updtd=updtd, cardId=cardId, owner=owner, is_private=is_private, fielddate=fielddate)

@with_hints(
    output_schema=dict(
        path=str,
        owner=str,
        boardId=str,
        is_private=bool,
        fielddate=str
    )
)
def myMap_board(recs):
    for rec in recs:
        boardId = rec.id
        document = rec.document
        if not "is_private" in document:
            continue
        is_private = bool(document["is_private"])
        if "ban" in document:
            if document["ban"] is True or document["ban"]=="y":
                continue
        fielddate = ""
        service = document["service"]
        if "created_at" in service:
            created_at = service["created_at"]["_$date"]
            date = created_at[:10]
        if date != "":
            fielddate = date
            yield Record(owner=rec.owner, path="finish.board.create", boardId=boardId, is_private=is_private, fielddate=fielddate)

@with_hints(
    output_schema=dict(
        path=str,
        owner=str,
        cardId=str,
        fielddate=str
    )
)
def myMap_like(recs):
    for rec in recs:
        like = rec.id
        owner = rec.owner
        yield Record(path="finish.card.like", owner=owner, cardId=rec.card, fielddate=time_from_object_id(like))

@with_hints(
    output_schema=dict(
        path=str,
        owner=str,
        cardId=str,
        fielddate=str
    )
)
def myMap_subscription(recs):
    for rec in recs:
        cls = rec._cls
        subscription = cls.split(".")[1]
        subscription = "finish." + subscription.replace("Subscription", ".subscribe")
        subscription = subscription.lower()
        if "compilation" in subscription:
            subscription = "click.card.daily.subscribe"
        owner = rec.owner
        yield Record(path=subscription, owner=owner, cardId=None, fielddate=time_from_object_id(rec.id))

@with_hints(
    output_schema=dict(
        owner=str
    )
)
def get_owners(recs):
    for rec in recs:
        owner = rec.id
        if owner == "":
            continue
        document = rec.document
        if "role" in document:
            continue
        if "labels" in document:
            if "toloker" in document["labels"]:
                continue
        yield Record(owner=owner)


@cli.statinfra_job

#def make_job(job, nirvana, statface_client):
def make_job(job, nirvana):

    ouput_directory = nirvana.directories[0]

    job = job.env(
        templates=dict(
            job_root=ouput_directory
        )
    )

    card_like = job.table("//home/collections-backups/db/prod/podborki/latest/card_like")
    card_like.map(myMap_like).put('$job_root/likes_dump')

    subscription = job.table("//home/collections-backups/db/prod/podborki/latest/subscription")
    subscription.map(myMap_subscription).put('$job_root/subscription_dump')

    comment = job.table("//home/collections-backups/db/prod/podborki/latest/card_comment")
    comment.map(myMap_comment).put('$job_root/comments_dump')

    owners = job.table("//home/collections-backups/db/prod/podborki/latest/user").map(get_owners)

    board = job.table("//home/collections-backups/db/prod/podborki/latest/board")
    board.map(myMap_board).join(owners, by='owner').project('path', 'boardId', 'is_private', 'fielddate').unique('path', 'boardId', 'is_private', 'fielddate').put('$job_root/boards_dump')

    cards = job.table("//home/collections-backups/db/prod/podborki/latest/card")
    cards.map(myMap_card).join(owners, by='owner').put('$job_root/cards_dump')

    return job

if __name__ == '__main__':
    cli.run()

