#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import datetime
import time
import re

@with_hints(
    output_schema=dict(
        actiond=str,
        actiontype=str,
        device=str,
        fielddate=str
    )
)
def myMap_sprav(recs):
    for rec in recs:
        fielddate = rec.fielddate
        if datetime.datetime.strptime(fielddate, '%Y-%m-%d').date() < datetime.datetime.strptime('2018-04-09', '%Y-%m-%d').date():
            continue

        device = "desktop"
        if "MOBILE_" in rec.app_type:
            device = "yandexApp"
        actiontype = "3"
        actiond = "review"
        yield Record(actiond=actiond, actiontype=actiontype, device=device, fielddate=fielddate)

def s_str(md):
    start_point = datetime.datetime.strptime(min(md), '%Y-%m-%d').date() - datetime.timedelta(days=30)
    if start_point < datetime.datetime.strptime("2018-04-09", '%Y-%m-%d').date():
        start_point = "2018-04-09"
    else:
        start_point = str(start_point)
    return start_point


@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"],
            tentative_pool_trees=["cloud"]
        ),
        templates=dict(
            job_root=nirvana.directories[0],
            tmp_root='//home/images/tmp'
        )
    )

    input_table=nirvana.input_tables[0]
    d = input_table.split("/")[-1]# options.dates

    district_data = job.table(input_table, ignore_missing=True)
    district_data_rep = district_data.project(ne.all(), actiond = 'action') \
        .groupby('actiontype', 'actiond', 'device', 'fielddate') \
        .aggregate(count = na.sum('hits')) \
        .project(ne.all(), service = ne.const('district')) \
        .put('$job_root/district/' + d)

    return job


if __name__ == '__main__':
    cli.run()

