#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import json
import datetime
import requests
import urllib
import urllib2


def parse_url(d1, d2, str_url, flag):
    data_list = []
    url_to_parse = "https://upload.stat.yandex-team.ru/Adhoc/rkam/" + str_url + "?" + \
            "service=_in_table_&device=_in_table_&actiontype=_in_table_&actiond=_in_table_&" + \
            "_type=json&_raw_data=1&_bldr_fill_missing_dates=0&scale=d" + \
            "&date_min=" + d1 + "&date_max=" + d2
    req = urllib2.Request(url_to_parse)
    req.add_header("StatRobotPassword", "aulifOR1a6o6pas")
    req.add_header("StatRobotUser", "robot_robot-collections")
    response = urllib2.urlopen(req)
    data_raw = json.load(response)
    stat_data = data_raw['values']
    for j in stat_data:
        row = [j['service'], j['actiontype'], j['actiond'], j['device'], j['hits'], j['fielddate'][:10], flag]
        if not "_total_" in row and not "Всего" in row:
            data_list.append(row)
    return data_list


def get_data():
    strdate = str(datetime.date.today() - datetime.timedelta(days=1))
    strdate_start = str(datetime.date.today() - datetime.timedelta(days=31))
    data1 = parse_url(strdate_start, strdate, "UGC_detailed_service_actiontype_withLogins", "main")
    data2 = parse_url(strdate_start, strdate, "UGC_detailed_service_actiontype", "additional")
    return data1 + data2


def final_action(driver):
    data_list = get_data()
    records = [Record(service=k[0], actiontype=k[1], actiond=k[2], device=k[3], hits=k[4], fielddate=k[5], flag=k[6]) for k in data_list]
    driver.write(output_table, records)


output_table = None

@cli.statinfra_job(final_action=final_action)

def make_job(job, nirvana):
    global output_table
    output_table = nirvana.output_tables[0]
    return job


if __name__ == '__main__':
    cli.run()

