#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    with_hints,
    extended_schema,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import datetime
import time
import re


@with_hints(output_schema=extended_schema())
def filter_dates(recs):
    for rec in recs:
        fielddate = datetime.datetime.strptime(rec.fielddate, '%Y-%m-%d').date()
        base = datetime.datetime.strptime(rec.d, '%Y-%m-%d').date()

        end_point = base + datetime.timedelta(days=1)
        start_point = end_point - datetime.timedelta(days=30)

        if fielddate < start_point or fielddate >= end_point:
            continue
        yield rec

def s_str(md):
    start_point = datetime.datetime.strptime(min(md), '%Y-%m-%d').date() - datetime.timedelta(days=30)
    if start_point < datetime.datetime.strptime("2018-04-09", '%Y-%m-%d').date():
        start_point = "2018-04-09"
    else:
        start_point = str(start_point)
    return start_point


@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"],
            tentative_pool_trees=["cloud"]
        ),
        templates=dict(
            job_root=nirvana.directories[0],
            tmp_root='//home/images/tmp'
        )
    )

    input_table = "//home/robot-ugc/export/global_ugc/user_actions_by_services"
    strdate = options.dates[-1]

    ugc2_data = job.table(input_table, ignore_missing=True)
    ugc2_data_rep = ugc2_data.project(ne.all(exclude='actiontype'),
            actiond='action',
            device=ne.const("desktop"),
            d=ne.const(strdate),
            actiontype2=ne.custom(lambda x: str(x), 'actiontype')
        ) \
        .map(filter_dates) \
        .groupby('actiontype2', 'actiond', 'fielddate', 'service', 'device') \
        .aggregate(count = na.sum('hits')) \
        .project(ne.all(exclude='actiontype2'), actiontype='actiontype2') \
        .put('$job_root/ugc/report_ugc2_30d')

    return job


if __name__ == '__main__':
    cli.run()

