#!/usr/bin/env python
# coding: utf-8

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import os
from datetime import datetime
import yt.wrapper as yt
import itertools
from collections import defaultdict

def filter_appropriate_part(data, appropriate_markup):
    appropriate_dict = { (x['query_text'], x['query_region_id']): x['query_info']['sufficiency'] for x in appropriate_markup }
    out_data = []
    for elem in data:
        sufficiency = appropriate_dict.get((elem['query_text'], elem['query_region_id']))
        if sufficiency is not None:
            elem['other']['sufficiency'] = sufficiency
            out_data.append(elem)
    return out_data


def filter_appropriate(job_root, params):
    country, platform, basket_type, comm = params
    appropriate_table = '{job_root}/no_bullshit_basket_final_candidates'.format(
        job_root=job_root
    )
    in_table = '{job_root}/{country}/{platform}/08_{basket_type}_merged_{comm}_resampled'.format(
        job_root=job_root,
        country=country,
        platform=platform,
        basket_type=basket_type,
        comm=comm
    )
    out_table = '{job_root}/{country}/{platform}/09_{basket_type}_merged_{comm}_appropriate'.format(
        job_root=job_root,
        country=country,
        platform=platform,
        basket_type=basket_type,
        comm=comm
    )
    data = list(yt.read_table(in_table))
    appropriate_markup = yt.read_table(appropriate_table)

    print datetime.now(), 'start ({}, {}, {}, {}), {} queries'.format(country, platform, basket_type, comm, len(data))
    out_data = filter_appropriate_part(data, appropriate_markup)
    print datetime.now(), 'done'

    yt.write_table(out_table, out_data)

    return out_table


def main(*args):
    queries_list, in2, in3, token, embed_key, html_file = args

    job_root='//home/images/dev/nerevar/baskets_img/2018Q1_v2'

    tables_list = []
    for tup in itertools.product(
        ['BY'], # 'RU', 'UA', 'KZ', 'UZ', 'exUSSR'
        ['desktop'], # 'touch'
        ['kpi'], # 'validate'
        ['comm', 'not_comm']
    ):
        table_name = filter_appropriate(job_root, tup)

        tables_list.append(table_name)
    return tables_list
