#!/usr/bin/env python
# coding: utf-8

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import os
from datetime import datetime
import yt.wrapper as yt
import itertools
from collections import defaultdict

def merge_final_basket(job_root, config, basket_type):
    out_data = []
    print datetime.now(), 'start', basket_type

    out_table = '{job_root}/images_{basket_type}_raw'.format(
        job_root=job_root,
        basket_type=basket_type
    )

    for tup in itertools.product(
        config['country_filter'],
        config['platform_filter'],
        config['final_comm_distribution'].keys()
    ):
        country, platform, comm = tup
        in_table = '{job_root}/{country}/{platform}/10_{basket_type}_{comm}_final'.format(
            job_root=job_root,
            country=country,
            platform=platform,
            basket_type=basket_type,
            comm=comm
        )
        cur_data = list(yt.read_table(in_table))
        print datetime.now(), 'got ({}, {}, {}), {} queries'.format(country, platform, comm, len(cur_data))
        out_data.extend(cur_data)

    print datetime.now(), 'done, {} queries'.format(len(out_data))

    out_data.sort(key=lambda x: (x['query_country'], -x['bucket']))
    yt.write_table(out_table, out_data)

    return out_table


def main(*args):
    queries_list, config_wrapped, in3, token, embed_key, html_file = args
    config = config_wrapped[0]

    job_root='//home/images/dev/nerevar/baskets_img/2018Q1_v2'

    tables_list = []
    for basket_type in ['kpi', 'validate']:
        table_names = merge_final_basket(job_root, config, basket_type)
        tables_list.append(table_names)

    return tables_list
