#!/usr/bin/env python
# coding: utf-8

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import os
from datetime import datetime
import yt.wrapper as yt
import itertools
from utils import resample_part

def resample_merged_comm(job_root, params, sample_ratio):
    country, platform, basket_type, comm = params
    in_table = '{job_root}/{country}/{platform}/07_{basket_type}_merged_{comm}'.format(
        job_root=job_root,
        country=country,
        platform=platform,
        basket_type=basket_type,
        comm=comm
    )
    out_table = '{job_root}/{country}/{platform}/08_{basket_type}_merged_{comm}_resampled'.format(
        job_root=job_root,
        country=country,
        platform=platform,
        basket_type=basket_type,
        comm=comm
    )
    data = list(yt.read_table(in_table))

    print datetime.now(), 'start ({}, {}, {}, {}), {} queries'.format(country, platform, basket_type, comm, len(data))
    if sample_ratio > 0.999:
        out_data = data
    else:
        out_data = resample_part(data, sample_ratio=sample_ratio, append_percentile=False)
    print datetime.now(), 'done'

    yt.write_table(out_table, out_data)

    return out_table


def main(*args):
    queries_list, in2, in3, token, embed_key, html_file = args

    job_root='//home/images/dev/nerevar/baskets_img/2018Q1_v2'

    tables_list = []
    sample_config = {'comm': 1.0, 'not_comm': 0.5}
    for tup in itertools.product(
        ['BY'], # 'RU', 'UA', 'KZ', 'UZ', 'exUSSR'
        ['desktop'], # 'touch'
        ['kpi'], # 'validate',
        ['comm', 'not_comm']
    ):
        table_name = resample_merged_comm(job_root, tup, sample_config[tup[3]])

        tables_list.append(table_name)
    return tables_list
