from collections import Counter
import random

def resample_part(data, sample_ratio=None, sample_abs=None, append_percentile=False):
    data_size = len(data)

    if sample_ratio is not None:
        target_number = int(data_size * sample_ratio)
    if sample_abs is not None:
        target_number = sample_abs

    if target_number > data_size:
        target_number = data_size
    if data_size == target_number:
        print "sampling is not needed"
        return data

    stats = Counter([x['bucket'] for x in data])
    cats = {bucket: count for bucket, count in stats.most_common()}
    max_bucket = max(cats.keys())
    print cats

    result = []

    cat_left = len(cats)
    for cat in sorted(cats, key=lambda x: cats[x]):
        ask = int(target_number // cat_left)
        if cats[cat] < ask:
            ask = cats[cat]

        print('ask {} from category {}'.format(ask, cat))
        sampled = random.sample([x for x in data if x['bucket'] == cat], ask)
        if append_percentile:
            for q in sampled:
                q['other']['bucket_percentile'] = float(cat) / max_bucket
        result += sampled
        target_number -= ask
        cat_left -= 1

    return result
