#!/usr/bin/env python
# coding: utf-8

import json


def main():
    dict_numbers = {}
    dict_path = {}

    with open('blockstat.dict') as f:
        for line in f:
            parts = [x.strip() for x in line.split(';')]
            dict_numbers[parts[0]] = parts[1]
            dict_path[parts[1]] = parts[0]

    with open('dict_numbers.json', 'w') as output_file:
        json_string = json.dumps(dict_numbers, ensure_ascii=False, indent=4).encode('utf8')
        output_file.write(json_string)

    with open('dict_path.json', 'w') as output_file:
        json_string = json.dumps(dict_path, ensure_ascii=False, indent=4).encode('utf8')
        output_file.write(json_string)


if __name__ == '__main__':
    main()
