!(function($) {

var BASE_COLLECTIONS_URL = 'https://yandex.ru';

if (window.location.href == 'https://localhost:9000/') {
    BASE_COLLECTIONS_URL = 'http://localhost:8686';
}

var HONEYPOTS_COUNT = 4;
var CARDS_PER_REQUEST = 16;


var IS_TRAINING = false;
var IS_EXAM = false;
var IS_TASK = true;
var IS_TASK_ORDERED = false;
var assignmentId = null;
var userStats = {};

var trainKnowCollections;
var userTemperaturesList = ['cold', 'cold', 'cold', 'cold', 'cold', 'warm', 'warm', 'warm', 'hot', 'very_hot'];
var trainActions = [];
var trainInitialUserActions = [];
var trainUserTemperature;
var lsTemperature;

try {
    lsTemperature = localStorage.getItem('collectionsUserTemperature');
} catch (e) {}

if (lsTemperature && lsTemperature.length > 0) {
    trainUserTemperature = lsTemperature;
} else {
    trainUserTemperature = userTemperaturesList[Math.floor(Math.random() * userTemperaturesList.length)];
    try {
        localStorage.setItem('collectionsUserTemperature', trainUserTemperature);
    } catch (e) {}
}

switch (trainUserTemperature) {
    // actions: [likes, cards, subscriptions]
    case 'cold':
        trainActions = [0, 0, 0];
        break;
    case 'warm':
        trainActions = [4, 2, 1];
        break;
    case 'hot':
        trainActions = [8, 5, 3];
        break;
    case 'very_hot':
        trainActions = [12, 8, 5];
        break;
}


var itemTemplate = '' +
'<div class="view view_idx_{{idx}}" style="background-color: {{background_color}}" data-cardid="{{id}}" data-idx="{{idx}}" data-pos="{{item_pos}}" data-reason="{{#if (eq reason.reason \'reason_1\')}}reason_1__{{reason.channel.slug}}{{else}}{{reason.reason}}{{/if}}" data-system_name="{{system_name}}" data-system_cgi="{{system_cgi}}">' +
    '<div class="image">' +
        '<img class="image__img" src="https://avatars.mds.yandex.net/get-pdb/{{content.0.content.group_id}}/{{content.0.content.avatars_key}}/s375" />' +
        '<!-- <div class="image__div" style="background-image: url(https://avatars.mds.yandex.net/get-pdb/{{content.0.content.group_id}}/{{content.0.content.avatars_key}}/s375);" /> -->' +
    '</div>' +
    '<div class="view__footer {{#if isInvertColorBlack}}view__footer_inverted{{/if}}">' +
        '<div class="board_title">' +
            '{{board.title}}' +
        '</div>' +
        '<div class="view__info">' +
            '<div class="view__title">{{description}}</div>' +
            '<p class="view__source">{{source_meta.page_domain_decoded}}</p>' +
        '</div>' +
        '<div class="view__ref"></div>' +
    '</div>' +
'</div>';

var gamma = 2.2;
var colorCache = {};
function isInvertColorBlack(color) {
    if (!color) {
        return true;
    }

    if (color in colorCache) {
        return colorCache[color];
    }

    var r = parseInt(color.slice(1, 3), 16) / 255,
        g = parseInt(color.slice(3, 5), 16) / 255,
        b = parseInt(color.slice(5, 7), 16) / 255,
        L = 0.2126 * Math.pow(r, gamma) + 0.7152 * Math.pow(g, gamma) + 0.0722 * Math.pow(b, gamma);

    return colorCache[color] = L > 0.4;
}

function randomIntFromInterval(min, max) {
    return Math.floor(Math.random() * (max - min + 1) + min);
}

function shuffle(array) {
    var currentIndex = array.length, temporaryValue, randomIndex;

    // While there remain elements to shuffle...
    while (0 !== currentIndex) {

        // Pick a remaining element...
        randomIndex = Math.floor(Math.random() * currentIndex);
        currentIndex -= 1;

        // And swap it with the current element.
        temporaryValue = array[currentIndex];
        array[currentIndex] = array[randomIndex];
        array[randomIndex] = temporaryValue;
    }

    return array;
}

/**
 * Возвращает случайные neededElements из массива sourceArray
 * Удаляет эти элементы из исходного массива
 * needFirst — возвратить первые элементы
 */
function getRandomElements(sourceArray, neededElements, needFirst) {
    var result = [];
    var idx;

    for (var i = 0; i < neededElements; i++) {
        idx = needFirst ? 0 : Math.floor(Math.random() * sourceArray.length);
        result.push(sourceArray[idx]);
        sourceArray.splice(idx, 1);
    }
    return result;
}

function getItemsFromList(source, from, count) {
    count || (count = 3);

    var result = [];
    for (var i = from; i < from + count; ++i) {
        result.push($.extend(true, {}, source[i]));
    }

    return result;
}


/**
 * Добавляет ключ key со значением value ко всем элементам в list
 */
function addKey(list, key, value) {
    for (var i = 0; i < list.length; ++i) {
        if (list[i]) {
            list[i][key] = value;
        }
    }
    return list;
}

function getData(system, assignmentId, count) {
    var withCredentials = system != 'nocookie';
    var params = '?utm_source=toloka-collections-feed' +
        '&rec_flags=update_history=false' +
        '&toloka_assignment_id=' + assignmentId +
        '&after=' + count;

    if (system == 'nocookie') {
        params += '&type=general';
    } else if (system == 'random') {
        params += '&type=random';
    } else if (system == 'major') {
        params += '&type=trash&rec_flags=trash_type=major';
    } else if (system == 'minor') {
        params += '&type=trash&rec_flags=trash_type=minor';
    } else if (system == 'hot') {
        params += '&type=general';
    } else {
        params += system;
    }
    return makeReq(withCredentials, params);
}

function makeReq(withCredentials, params) {
    return $.ajax({
        type: 'GET',
        url: BASE_COLLECTIONS_URL + '/collections/api/user/feed/anonymous' + params,
        dataType: 'json',
        xhrFields: { withCredentials: withCredentials },
        headers: {
            'X-Yandex-Collections-Toloka': '1'
        },
        crossDomain: true,
        cache: false
    });
}

function updateUserStats(params, callback) {
    $.ajax({
        type: 'GET',
        url: BASE_COLLECTIONS_URL + '/collections/api/user/stats' + params,
        dataType: 'json',
        xhrFields: { withCredentials: true },
        crossDomain: true,
        cache: false
    }).then(function(data) {
        userStats = data;
        if (callback) {
            callback(data);
        }
    });
}

function userStatsToUserActions(stats) {
    // actions: [likes, cards, subscriptions]
    return [
        stats.own_likes,
        stats.cards,
        stats.board_subscriptions + stats.channel_subscriptions + stats.user_subscriptions
    ]
}

var cardTemplate = null;

function renderItem(item, idx) {
    if (!item) {
        item = {};
    }
    item['isInvertColorBlack'] = true;
    item['background_color'] = '#758B9A';
    try {
        var color = item.content[0].content.avatars_meta.color_wiz_back;
        item['isInvertColorBlack'] = !isInvertColorBlack(color);
        item['background_color'] = color;
    } catch (err) {}

    item['idx'] = idx + 1;
    return cardTemplate(item);
}

var globalRequests = [];
var globalResults = [];
function requestNext(callback) {
    if (globalRequests.length) {
        var currentRequests = globalRequests.shift();

        $.when.apply(undefined, [
            getData(currentRequests[0], assignmentId, CARDS_PER_REQUEST + 6),
            getData(currentRequests[1], assignmentId, CARDS_PER_REQUEST + 6),
        ])
        .then(function() {
            globalResults.push([].slice.call(arguments));
            requestNext(callback);
        }, _onAjaxError);
    } else {
        callback(globalResults);
    }
}

function _onAjaxError(msg) {
    alert(
        'Ошибка запроса за данными :(\n' +
        'Попробуйте обновить страницу через Ctrl+F5 или Ctrl+R\n' +
        'Если не поможет — то в инструкции есть ещё 3 шага, которые помогут загрузить задание\n' +
        'Если и это не поможет — то пишите в поддержку\n' +
        'И приложите скриншот ошибки и консоли как указано в инструкции — это поможет разобраться с проблемой\n' +
        msg
    );
}

exports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function(options) {
    TolokaHandlebarsTaskSuite.call(this, options);
}, {
    onRender: function() {
        assignmentId = this.getAssignment().getId() || 'default_assingment_id';
        cardTemplate = Handlebars.compile(itemTemplate);

        updateUserStats(
            '?utm_source=toloka-collections-feed&toloka_assignment_id=' + assignmentId,
            function(stats) {
                trainInitialUserActions = userStatsToUserActions(stats);
            }
        );

        if (!IS_TRAINING) {
            var $body = $('body');
            this._onCheckboxChanged = this._onCheckboxChange.bind(this);
            $body.on('click', '.view', this._onViewClick);
            $body.on('change', '.choice__checkbox input', this._onCheckboxChanged);
            $body.on('error', '.image__img', this._onImgError);

            if (IS_TASK) {
                if (IS_TASK_ORDERED) {
                    this._initOrderedTasks();
                } else {
                    this._loadTasks();
                }
            } else {
                this._initExam();
            }
        }
    },

    /**
     * Возвращает массив систем с указанием количества карточек в каждой
     */
    _getSystemsCardsCount: function() {
        var allTasksData = _.map(this.getTasks(), function(task) { return task.getTemplateData()['json_input']; });
        var mainTasks = _.filter(allTasksData, {'type': 'task'});
        var honeypots = _.filter(allTasksData, {'type': 'hp'});

        var results_tasks = [];
        if (mainTasks.length > 0) {
            results_tasks = _.clone(mainTasks[0]['systems']);
            results_tasks[0]['count'] = 3 * mainTasks.length;
            results_tasks[1]['count'] = 3 * mainTasks.length;
            results_tasks[0]['type'] = 'main';
            results_tasks[1]['type'] = 'main';
        }

        var results_hp = [];
        honeypots.forEach(function(hp) {
            hp['systems'].forEach(function(system) {
                var found = _.find(results_hp, {'name': system.name, 'cgi': system.cgi});
                if (!found) {
                    var newItem = _.clone(system);
                    newItem['count'] = 3;
                    newItem['type'] = 'hp';
                    results_hp.push(newItem);
                } else {
                    found['count'] += 3;
                }
            });
        });

        return [results_tasks, results_hp];
    },

    _parseMainAjaxResults: function(ajaxResults) {
        var results = [];
        for (var step = 0; step < ajaxResults.length; ++step) {
            for (var systemIndex = 0; systemIndex < ajaxResults[step].length; ++systemIndex) {
                results[systemIndex] = (results[systemIndex] || [])
                    .concat(ajaxResults[step][systemIndex][0].results);
            }
        }
        return results;
    },

    _parseHpAjaxResults: function(ajaxResults) {
        var results = [];
        for (var systemIndex = 0; systemIndex < ajaxResults.length; ++systemIndex) {
            results[systemIndex] = (results[systemIndex] || [])
                .concat(ajaxResults[systemIndex][0].results);
        }
        return results;
    },

    /**
     * Загружает задания для основных систем, скачивает параллельно 2 системы
     * последовательно пачками по `CARDS_PER_REQUEST` карточек
     */
    _loadMainSystems: function(mainSystems, callback) {
        // console.log('try load mainSystems', mainSystems);
        var steps = mainSystems[0].count / CARDS_PER_REQUEST;
        steps += 1;

        globalRequests = [];
        for (var i = 0; i < steps; ++i) {
            globalRequests.push([mainSystems[0].cgi, mainSystems[1].cgi]);
        }

        requestNext(function(ajaxResults) {
            callback(ajaxResults);
        });
    },

    /**
     * Параллельно загружает все ханипоты сразу
     */
    _loadHpSystems: function(hpSystems, callback) {
        // console.log('try load hp', hpSystems);

        $.when.apply(undefined, _.map(hpSystems, function(system) {
            return getData(system.cgi, assignmentId, system.count + 15);
        }))
        .then(function() {
            callback([].slice.call(arguments));
        }, _onAjaxError);
    },

    _initTasks: function() {
        var _this = this;
        // console.log('_tasksSystems', this._tasksSystems, this._tasksData);
        // console.log('_hpSystems', this._hpSystems, this._hpData);

        // проверяет ожидаемое и загруженное количество карточек
        for (var i = 0; i < this._tasksSystems.length; ++i) {
            if (this._tasksSystems[i].count > this._tasksData[i].length) {
                _onAjaxError('err code 1 ' + i + ' cnt ' + this._tasksSystems[i].count + ' - ' + this._tasksData[i].length);
                return;
            }
        }
        for (var i = 0; i < this._hpSystems.length; ++i) {
            if (this._hpSystems[i].count > this._hpData[i].length) {
                _onAjaxError('err code 2 ' + i + ' cnt ' + this._hpSystems[i].count + ' - ' + this._hpData[i].length);
                return;
            }
        }

        var allTasks = [];
        var allTasksInputData = _.map(this.getTasks(), function(task) { return task.getTemplateData()['json_input']; });
        var mainTasks = _.filter(allTasksInputData, {'type': 'task'});

        // формируем боевые задания
        for (var i = 0; i < mainTasks.length; ++i) {
            var cards = [];
            for (var system = 0; system <= 1; ++system) {
                getItemsFromList(this._tasksData[system], i * 3).forEach(function(item, idx) {
                    item['system_name'] = _this._tasksSystems[system].name;
                    item['system_cgi'] = _this._tasksSystems[system].cgi;
                    item['item_pos'] = i * 3 + idx;
                    cards.push(item);
                });
            }
            allTasks.push(shuffle(cards));
        }
        shuffle(allTasks);

        // инициализируем задания (микротаски)
        this.getTasks().forEach(function(task) {
            var taskData = task.getTemplateData()['json_input'];

            if (taskData['type'] == 'task') {
                // для обычных заданий выбираем случайные данные
                task.init(allTasks.pop());
            } else if (taskData['type'] == 'hp') {
                // формируем ханипот в соответствии со входными системами
                task.init(_this._buildHoneypotData.call(_this, taskData));
            }
        });
    },

    /**
     * Формирует 6 карточек ханипотов, в соответствии с системами в taskData
     */
    _buildHoneypotData: function(taskData) {
        var _this = this;
        var cards = [];
        for (var system = 0; system <= 1; ++system) {
            var system_name = taskData['systems'][system]['name'];
            var system_index = _.findIndex(_this._hpSystems, {'name': system_name});
            getRandomElements(_this._hpData[system_index], 3).forEach(function(item) {
                item['system_name'] = _this._hpSystems[system_index].name;
                item['system_cgi'] = _this._hpSystems[system_index].cgi;
                cards.push(item);
            });
        }
        return shuffle(cards);
    },

    /**
     * Аяксом параллельно загружает карточки тасков и ханипотов
     */
    _loadTasks: function() {
        var _this = this;

        var systems = this._getSystemsCardsCount();
        _this._tasksSystems = systems[0];
        _this._hpSystems = systems[1];
        _this._tasksData = [];
        _this._hpData = [];

        /*
        if (Math.random() >= 0.5) {
            // случайно переставляем местами системы
            var tmpSystem = systems[0];
            systems[0] = systems[1];
            systems[1] = tmpSystem;
        }
        */

        if (_this._tasksSystems.length > 0) {
            this._loadMainSystems(_this._tasksSystems, function(ajaxResults) {
                _this._tasksData = _this._parseMainAjaxResults(ajaxResults);

                if (_this._hpSystems.length > 0) {
                    _this._loadHpSystems(_this._hpSystems, function(ajaxResults) {
                        _this._hpData = _this._parseHpAjaxResults(ajaxResults);

                        _this._initTasks.call(_this);
                    });
                } else {
                    _this._initTasks.call(_this);
                }
            });
        } else if (_this._hpSystems.length > 0) {
            // задание состоит только из ханипотов
            _this._loadHpSystems(_this._hpSystems, function(ajaxResults) {
                _this._hpData = _this._parseHpAjaxResults(ajaxResults);

                _this._initTasks.call(_this);
            });
        }
    },

    _initOrderedTasks: function() {
        var _this = this;
        var tasks = _this.getTasks();
        var tasksCount = tasks.length;

        // прямой порядок запросов
        $.when.apply(undefined, [
                getData('', assignmentId, (tasksCount-HONEYPOTS_COUNT/2 + 3) * 3 + 15),
                getData('minor', assignmentId, (HONEYPOTS_COUNT/2) * 3 + 15),
                getData('major', assignmentId, (HONEYPOTS_COUNT/2) * 3 + 15)
            ])
            .then(function(system1, hp_minor, hp_major) {
                _this._onAjaxOrderedLoaded(_this, system1, hp_minor, hp_major);
            }, _this._onAjaxError);
    },

    _onAjaxError: function(msg) {
        alert(
            'Ошибка запроса за данными :(\n' +
            'Попробуйте обновить страницу через Ctrl+F5 или Ctrl+R\n' +
            'Если не поможет — то в инструкции есть ещё 3 шага, которые помогут загрузить задание\n' +
            'Если и это не поможет — то пишите в поддержку\n' +
            'И приложите скриншот ошибки и консоли как указано в инструкции — это поможет разобраться с проблемой\n' +
            msg
        );
    },

    _onAjaxOrderedLoaded: function(_this, system1, hp_minor, hp_major) {
        var tasks = _this.getTasks();
        var tasksCount = tasks.length;
        var itemData = tasks[0].getTemplateData();
        var ordered_count = itemData.json_input.ordered_count;

        var allTasks = [];
        system1 = system1[0].results;
        hp_minor && (hp_minor = hp_minor[0].results);
        hp_major && (hp_major = hp_major[0].results);

        // TODO: проверка на то, что не все карточки загрузились, а то сейчас карточки могут не загружаться

        for (var i = 0; i < tasksCount-HONEYPOTS_COUNT; ++i) {
            allTasks.push(shuffle(
                addKey(getItemsFromList(system1, i * 3), 'system', '&rnd=prod').concat(
                addKey(getItemsFromList(system1, (i + ordered_count) * 3), 'system', ('&rnd=prod_plus_'+ordered_count)))
            ));
        }

        allTasks.push(shuffle(
            addKey(getRandomElements(system1, 3), 'system', 'prod_for_hp').concat(
            addKey(getRandomElements(hp_minor, 3), 'system', 'minor'))
        ));
        allTasks.push(shuffle(
            addKey(getRandomElements(system1, 3), 'system', 'prod_for_hp').concat(
            addKey(getRandomElements(hp_minor, 3), 'system', 'minor'))
        ));
        allTasks.push(shuffle(
            addKey(getRandomElements(system1, 3), 'system', 'prod_for_hp').concat(
            addKey(getRandomElements(hp_major, 3), 'system', 'major'))
        ));
        allTasks.push(shuffle(
            addKey(getRandomElements(system1, 3), 'system', 'prod_for_hp').concat(
            addKey(getRandomElements(hp_major, 3), 'system', 'major'))
        ));

        shuffle(allTasks);

        _this.getTasks().forEach(function(task, idx) {
            task.init(allTasks[idx]);
        });
    },

    _onAjaxExamLoaded: function(_this, system_hot, system_random, system_nocookie, system_minor, system_major) {
        system_hot = system_hot[0].results;
        system_random = system_random[0].results;
        system_nocookie = system_nocookie[0].results;
        system_minor = system_minor[0].results;
        system_major = system_major[0].results;

        var allTasks = [];

        for (var i = 0; i < 3; ++i) {
            allTasks.push(shuffle(
                addKey(getRandomElements(system_hot, 3), 'system', 'hot').concat(
                addKey(getRandomElements(system_nocookie, 3), 'system', 'nocookie'))
            ));
            allTasks.push(shuffle(
                addKey(getRandomElements(system_hot, 3), 'system', 'hot').concat(
                addKey(getRandomElements(system_random, 3), 'system', 'random'))
            ));
        }
        for (i = 0; i < 2; ++i) {
            allTasks.push(shuffle(
                addKey(getRandomElements(system_hot, 3), 'system', 'hot').concat(
                addKey(getRandomElements(system_major, 3), 'system', 'major'))
            ));
            allTasks.push(shuffle(
                addKey(getRandomElements(system_hot, 3), 'system', 'hot').concat(
                addKey(getRandomElements(system_minor, 3), 'system', 'minor'))
            ));
            allTasks.push(shuffle(
                addKey(getRandomElements(system_random, 3), 'system', 'random').concat(
                addKey(getRandomElements(system_major, 3), 'system', 'major'))
            ));
            allTasks.push(shuffle(
                addKey(getRandomElements(system_random, 3), 'system', 'random').concat(
                addKey(getRandomElements(system_minor, 3), 'system', 'minor'))
            ));
        }
        allTasks.push(shuffle(
            addKey(getRandomElements(system_nocookie, 3), 'system', 'nocookie').concat(
            addKey(getRandomElements(system_major, 3), 'system', 'major'))
        ));
        allTasks.push(shuffle(
            addKey(getRandomElements(system_nocookie, 3), 'system', 'nocookie').concat(
            addKey(getRandomElements(system_minor, 3), 'system', 'minor'))
        ));

        shuffle(allTasks);

        _this.getTasks().forEach(function(task, idx) {
            task.init(allTasks[idx]);
        });

    },

    _initExam: function() {
        var _this = this;
        var tasks = _this.getTasks();
        var tasksCount = tasks.length;

        var requests = [
            getData('hot', assignmentId, 10*3 + 15),
            getData('random', assignmentId, 7*3 + 15),
            getData('nocookie', assignmentId, 5*3 + 15),
            getData('minor', assignmentId, 5*3 + 15),
            getData('major', assignmentId, 5*3 + 15)
        ];

        $.when.apply(undefined, requests)
            .then(function(s1, s2, s3, s4, s5) {
                _this._onAjaxExamLoaded(_this, s1, s2, s3, s4, s5);
            }, _this._onAjaxError);
    },


    _onCheckboxChange: function(e) {
        this.getFocusedTask()._onCheckboxChange(e);
    },

    _onViewClick: function(e) {
        var $view = $(this);
        if (!$view.hasClass('view')) {
            $view = $view.parents('.view');
        }

        var $target = $(e.target);
        // проверяем что не кликаем по чекбоксу внутри view
        if ($target.hasClass('choice__checkbox') || $target.parents('.choice__checkbox').length) {
            return;
        }

        $view.find('.choice__checkbox input').click();
    },

    _onImgError: function() {
        var src = this.src;
        if (src.indexOf('retry') === -1) {
            // одна попытка перезагрузить картинку
            this.src += '?retry=' + new Date().getTime();
        }
    },

    onDestroy: function() {
        var $body = $('body');
        $body.off('click', '.view');
        $body.off('change', '.choice__checkbox input');
        $body.off('error', '.image__img');
    }
});

exports.Task = extend(TolokaHandlebarsTask, function(options) {
    TolokaHandlebarsTask.call(this, options);
}, {

    onRender: function() {
        this.result = {
            cards: [],
            selectedCount: 0
        };

        if (IS_TRAINING) {
            this._initTrain();
        }
    },

    init: function(cards) {
        this.result = {
            cards: [],
            selectedCount: 0
        };

        this.renderCards(cards);
        this.transferCheckboxes();
    },

    renderCards: function(items) {
        var _this = this;
        var domElem = $(this.getDOMElement());
        var $results = domElem.find('.results');

        var itemsHtml = '';
        items.forEach(function(item, idx) {
            itemsHtml += renderItem(item, idx);
        });
        itemsHtml = $(itemsHtml);
        $results.html(itemsHtml);

        $results.find('.view').each(function(idx, item) {
            _this.result.cards.push(_this._getCardParams($(item)));
        })
    },

    transferCheckboxes: function() {
        var domElem = $(this.getDOMElement());

        for (var i = 1; i <= 6; ++i) {
            domElem.find('.view_idx_' + i + ' .view__ref').prepend(
                domElem.find('.choice__checkbox_idx_' + i)
            );
        }
    },

    _getCardParams: function($view) {
        return {
            idx: +$view.data('idx'),
            pos: +$view.data('pos'),
            card_id: $view.data('cardid'),
            reason: $view.data('reason'),
            system_name: $view.data('system_name'),
            system_cgi: $view.data('system_cgi'),
            card: {
                img: $view.find('.image__img').attr('src'),
                title: $view.find('.person__description').text(),
                descr: $view.find('.view__title').text(),
                page: $view.find('.view__source').text()
            },
            selected: false
        }
    },

    _setSelected: function(idx, status) {
        for (var i = 0; i < this.result.cards.length; ++i) {
            if (this.result.cards[i].idx == idx) {
                this.result.cards[i].selected = status;
                break;
            }
        }
        this.result.selectedCount += status ? 1 : -1;
    },

    _onCheckboxChange: function(e) {
        var $checkbox = $(e.target);
        var $view = $checkbox.parents('.view');
        var view_idx = +$view.data('idx');

        if ($checkbox.prop('checked')) {
            $view.addClass('view_selected');
            this._setSelected(view_idx, true);
        } else {
            $view.removeClass('view_selected');
            this._setSelected(view_idx, false);
        }
    },

    /**
     * Предварительный фильтр для исходных данных
     * Можно добавить или удалить что-то, что потом отрисуется в шаблоне
     */
    getTemplateData: function() {
        var data = TolokaHandlebarsTask.prototype.getTemplateData.apply(this, arguments);

        if (data.json_input && data.json_input.type && data.json_input.type === 'training') {
            IS_TRAINING = true;
            IS_EXAM = false;
            IS_TASK = false;
        } else if (data.json_input && data.json_input.type && data.json_input.type === 'exam') {
            IS_TRAINING = false;
            IS_EXAM = true;
            IS_TASK = false;
        } else if (data.json_input && data.json_input.type && data.json_input.type === 'ordered') {
            IS_TASK_ORDERED = true;
        }

        return data;
    },

    _initTrain: function() {
        var $this = $(this.getDOMElement());
        var _this = this;
        $this.addClass('task_type_training');

        $this.find('.training_to_step1').click(function() {
            if (trainUserTemperature != 'cold') {
                $this.find('.training_step1').slideDown();
            } else {
                _this.isTrainingFinished = true;

                setTimeout(function() {
                    $this.find('.training_step4').slideDown();
                }, 1000);
            }

        });

        $this.find('.training_to_step2').click(function() {
            var value = $this.find('input[name=know_collections]:checked').val();
            trainKnowCollections = value;
            if (value === undefined) {
                $this.find('.training_to_step2 .button__label').text('Сначала выберите пункт выше, а потом жмите сюда');
            } else {
                var isError = false;

                if (trainInitialUserActions.length > 0) {
                    // likes, cards, subs
                    if (trainInitialUserActions[0] > 50 || trainInitialUserActions[1] > 500 || trainInitialUserActions[2] > 100) {
                        isError = true;
                        $('.training_error_toloker').show();
                    }
                }

                if (!isError) {
                    $this.find('.train_likes_count').html(trainActions[0]);
                    $this.find('.train_cards_count').html(trainActions[1]);
                    $this.find('.train_subs_count').html(trainActions[2]);

                    $this.find('.training_step2').slideDown();
                }
            }
        });

        $this.find('.collections-link').click(function() {
            _this.isCollectionsClicked = true;
            setTimeout(function() {
                $this.find('.training_step3').show();
            }, 500);
        });

        $this.find('.training_to_step4').click(function() {
            if (_this.isCollectionsClicked) {
                updateUserStats(
                    '?utm_source=toloka-collections-feed&toloka_assignment_id=' + assignmentId,
                    function(stats) {
                        var currentUserActions = userStatsToUserActions(stats);

                        var isOk = true;
                        var likesDiff = trainActions[0] - (currentUserActions[0] - trainInitialUserActions[0]);
                        var cardsDiff = trainActions[1] - (currentUserActions[1] - trainInitialUserActions[1]);
                        var subsDiff = trainActions[2] - (currentUserActions[2] - trainInitialUserActions[2]);

                        if (likesDiff > 0) {
                            alert('Нужно ещё ' + likesDiff + ' лайков');
                            isOk = false;
                        }
                        if (cardsDiff > 0) {
                            alert('Нужно ещё ' + cardsDiff + ' добавлений карточек в избранное');
                            isOk = false;
                        }
                        if (subsDiff > 0) {
                            alert('Нужно ещё ' + subsDiff + ' подписок на каналы');
                            isOk = false;
                        }

                        if (isOk) {
                            _this.isTrainingFinished = true;

                            setTimeout(function() {
                                $this.find('.training_step4').slideDown();
                            }, 1000);
                        }
                    });
            } else {
                $this.find('.training_to_step4 .button__label').text('Сначала зайдите в Коллекции');
            }
        });
    },

    /**
     * Обработчик нажатия горячих клавиш
     */
    onKey: function(key) {
        var $checkbox = $(this.getDOMElement()).find('.choice__checkbox_idx_' + key + ' input');

        if ($checkbox.length > 0) {
            $checkbox.click();
        }
    },

    addError: function(message, field, errors) {
        errors || (errors = {
            task_id: this.getOptions().task.id,
            errors: {}
        });
        errors.errors[field] = {
            message: message
        };

        return errors;
    },

    /**
     * Возвращает количество выбранных карточек ханипотов
     */
    _calcSelectedHpCount: function(sourceData, cards) {
        var selected = {}
        cards.forEach(function(card) {
            if (!selected[card.system_name]) {
                selected[card.system_name] = 0;
            }
            selected[card.system_name] += +card.selected;
        });

        // console.log('_calcSelectedHpCount', sourceData, cards, selected, selected[sourceData.systems[1].name]);
        return selected[sourceData.systems[1].name]
    },

    /**
     * Валидация задания
     */
    validate: function(solution) {
        var errors = TolokaHandlebarsTask.prototype.validate.apply(this, arguments);

        if (IS_TRAINING) {
            if (this.getOptions().task.id === 0) {
                // валидация только для 0-го задания
                var $this = $(this.getDOMElement());
                var value = $this.find('input[name=know_collections]:checked').val();

                if (value === undefined) {
                    errors = this.addError('Ошибка. Сначала пункт про знание Коллекций', '__TASK__', errors);
                } else if (!this.isCollectionsClicked) {
                    errors = this.addError('Ошибка. Сначала выберите и сохраните интересующие вас 3-6 тем', '__TASK__', errors);
                } else if (!this.isTrainingFinished) {
                    errors = this.addError('Ошибка. Тренировка ещё не закончена. Лайкайте картинки в Коллекциях, а после внизу нажмите "Проверить"', '__TASK__', errors);
                }
            }
            return errors;
        }

        if (this.result.selectedCount != 3) {
            errors = this.addError('Выберите ровно 3 подходящие картинки', '__TASK__', errors);
        }

        var taskData = this.getTemplateData()['json_input'];
        if (taskData['type'] == 'hp') {
            this.setSolutionOutputValue('golden', this._calcSelectedHpCount(taskData, this.result.cards));
        }

        return errors;
    },

    /**
     * Формирует результирующий json output
     */
    getSolution: function() {
        var solution = TolokaHandlebarsTask.prototype.getSolution.call(this);

        if (!this.getWorkspaceOptions().isReadOnly) {
            if (IS_TRAINING) {
                // solution.output_values['json_output'] = {
                //     know_collections: solution.output_values['know_collections']
                // };
                solution.output_values['json_output'] = 'train1';
            } else {
                solution.output_values['json_output'] = $.extend(true, {}, this.result);
                solution.output_values['json_output']['assignmentId'] = assignmentId;
                solution.output_values['json_output']['userStats'] = userStats;
            }

            delete solution.output_values['know_collections'];
            delete solution.output_values['good1'];
            delete solution.output_values['good2'];
            delete solution.output_values['good3'];
            delete solution.output_values['good4'];
            delete solution.output_values['good5'];
            delete solution.output_values['good6'];
        }

        // console.info(solution);

        return solution;
    },

    onDestroy: function() {}
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function() {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}

Handlebars.registerHelper('eq', function () {
    var args = Array.prototype.slice.call(arguments, 0, -1);
    return args.every(function (expression) {
        return args[0] === expression;
    });
});

}(jQuery));
