# -*- coding: utf-8 -*-

import pandas as pd
from helpers import get_cards_positions_clicks, get_top_position, is_worker_cheater, calc_hp_skill


def main(*args):
    in1, in2, in3, token, any_param, html_file = args

    if len(in1) == 0:
        return []

    df = pd.DataFrame(in1)

    df['cards_count'] = df['outputValues'].apply(lambda x: len(x['json_output']['cards']))
    df = df.loc[df['cards_count'] == 6]

    # ======= 1. Найти читеров 1-2-3 =======
    df['positions_clicks'] = df['outputValues'].apply(get_cards_positions_clicks)
    df['positions_clicks_list'] = df['positions_clicks'].apply(lambda x: x.values())
    df['positions_clicks_str'] = df['positions_clicks_list'].apply(lambda x: '-'.join([str(i) for i in x]))

    cheaters = df.groupby('assignmentId').agg({
        'positions_clicks_str': get_top_position,
        'workerId': 'first'
    }).reset_index()
    cheaters['top_combination'] = cheaters['positions_clicks_str'].apply(lambda x: x[0])
    cheaters['top_combination_count'] = cheaters['positions_clicks_str'].apply(lambda x: x[1])
    cheaters['is_cheater'] = cheaters.apply(is_worker_cheater, axis=1)

    cheaters_list = cheaters.groupby('workerId').agg({
        'is_cheater': 'first'
    }).reset_index()

    # ======= 2. Скилл по ханипотам =======
    grouped_by_worker = df \
        .sort_values(by='submitTs', ascending=False) \
        .groupby('workerId') \
        .agg({
            'outputValues': calc_hp_skill
        }) \
        .reset_index()

    grouped_by_worker.columns = ['workerId', 'skillValue']

    print grouped_by_worker.skillValue.describe()
    print grouped_by_worker.skillValue.value_counts().sort_index()

    # ======= 2. Смёржить результаты =======
    df_skills = pd.merge(grouped_by_worker, cheaters_list, on=['workerId'])

    print grouped_by_worker.shape
    print cheaters_list.shape
    print df_skills.shape

    df_skills['totalSkill'] = df_skills.apply(lambda x: x['is_cheater'] or x['skillValue'], axis=1)

    print df_skills[df_skills.totalSkill > 0].shape

    result = []
    for item in df_skills.T.to_dict().values():
        if item['totalSkill'] > 0:
            result.append({
                'workerId': item['workerId'],
                # Pollux ya_collections_feed_main https://toloka.yandex.com/requester/quality/skill/8697
                'skillId': 8697,
                'skillValue': item['totalSkill']
            })

    return result
