#!/usr/bin/env python
# -*- coding: utf-8 -*-

import pandas as pd
from collections import defaultdict, Counter


def extract_systems(outputValues):
    systems = Counter()
    for card in outputValues['json_output']['cards']:
        systems[card['system_name']] += int(card['selected'])
    return systems.most_common()


def get_user_actions_from_json(user_stats):
    return [
        user_stats.get('own_likes', 0),
        user_stats.get('cards', 0),
        user_stats.get('board_subscriptions', 0) + user_stats.get('channel_subscriptions', 0) + user_stats.get('user_subscriptions', 0),
    ]


def get_user_actions_count(groups):
    row = groups.iloc[0]
    user_actions = get_user_actions_from_json(row['json_output']['userStats'])
    user_actions.append(user_actions[0] + user_actions[1] + user_actions[2])
    user_actions.append(len(groups))
    return user_actions


def calc_user_temperature(stats):
    # stats: [likes, cards, subscriptions]
    if stats[0] <= 0 and stats[1] <= 0 and stats[2] <= 0:
        return 'cold'
    if stats[0] <= 8 and stats[1] <= 5 and stats[2] <= 3:
        return 'warm'
    if stats[0] <= 20 and stats[1] <= 10 and stats[2] <= 8:
        return 'hot'
    if stats[0] <= 40 and stats[1] <= 20 and stats[2] <= 20:
        return 'very_hot'
    if stats[0] <= 100 and stats[1] <= 100 and stats[2] <= 100:
        return 'boiling'
    return 'extremal'


def get_cards_positions_clicks(outputValues):
    positions = Counter()
    for card in outputValues['json_output']['cards']:
        positions[card['idx']] += int(card['selected'])
    return dict(positions)


def get_top_position(groups):
    positions = Counter()
    for idx, positions_clicks_str in groups.iteritems():
        positions[positions_clicks_str] += 1
    return positions.most_common()[0]


def is_worker_cheater(row):
    return int(
        row['top_combination_count'] >= 10
        or (row['top_combination_count'] >= 8 and row['top_combination'] == '1-1-1-0-0-0')
        or (row['top_combination_count'] >= 8 and row['top_combination'] == '0-0-0-1-1-1')
        or (row['top_combination_count'] >= 9 and row['top_combination'] == '0-1-1-0-1-0')
    )

