!(function($) {

    var TASKS_PER_PAGE = 12;

    var assignmentId = null;
    var userStats = {};

    var trainInitialUserActions = [];

    var itemTemplate = '' +
'<div class="view view_idx_{{idx}}" style="background-color: {{background_color}}" data-cardid="{{id}}" data-idx="{{idx}}" data-reason="{{#if (eq reason.reason \'reason_1\')}}reason_1__{{reason.channel.slug}}{{else}}{{reason.reason}}{{/if}}" data-system="{{system}}">' +
    '<div class="image">' +
        // '<img class="image__img" src="https://avatars.mds.yandex.net/get-pdb/{{content.0.content.group_id}}/{{content.0.content.avatars_key}}/s375" />' +
        '<div class="image__div" style="background-image: url(https://avatars.mds.yandex.net/get-pdb/{{content.0.content.group_id}}/{{content.0.content.avatars_key}}/s375);" />' +
    '</div>' +
    '<div class="view__footer {{#if isInvertColorBlack}}view__footer_inverted{{/if}}">' +
        '<div class="board_title">' +
            '{{board.title}}' +
        '</div>' +
        '<div class="view__info">' +
            '<div class="view__title">{{description}}</div>' +
            '<p class="view__source">{{source_meta.page_domain_decoded}}</p>' +
        '</div>' +
        '<div class="view__ref"></div>' +
    '</div>' +
'</div>' +
'{{#if (eq idx 3)}}' +
'<div class="break"></div>' +
'{{/if}}';

    var gamma = 2.2;
    var colorCache = {};
    function isInvertColorBlack(color) {
        if (!color) {
            return true;
        }

        if (color in colorCache) {
            return colorCache[color];
        }

        var r = parseInt(color.slice(1, 3), 16) / 255,
            g = parseInt(color.slice(3, 5), 16) / 255,
            b = parseInt(color.slice(5, 7), 16) / 255,
            L = 0.2126 * Math.pow(r, gamma) + 0.7152 * Math.pow(g, gamma) + 0.0722 * Math.pow(b, gamma);

        return colorCache[color] = L > 0.4;
    }

    function randomIntFromInterval(min, max) {
        return Math.floor(Math.random() * (max - min + 1) + min);
    }

    function shuffle(array) {
        var currentIndex = array.length, temporaryValue, randomIndex;

        // While there remain elements to shuffle...
        while (0 !== currentIndex) {

            // Pick a remaining element...
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex -= 1;

            // And swap it with the current element.
            temporaryValue = array[currentIndex];
            array[currentIndex] = array[randomIndex];
            array[randomIndex] = temporaryValue;
        }

        return array;
    }

    /**
     * Возвращает случайные neededElements из массива sourceArray
     * Удаляет эти элементы из исходного массива
     * needFirst — возвратить первые элементы
     */
    function getRandomElements(sourceArray, neededElements, needFirst) {
        var result = [];
        var idx;

        for (var i = 0; i < neededElements; i++) {
            idx = needFirst ? 0 : Math.floor(Math.random() * sourceArray.length);
            result.push(sourceArray[idx]);
            sourceArray.splice(idx, 1);
        }
        return result;
    }

    /**
     * Добавляет ключ key со значением value ко всем элементам в list
     */
    function addKey(list, key, value) {
        for (var i = 0; i < list.length; ++i) {
            if (list[i]) {
                list[i][key] = value;
            }
        }
        return list;
    }

    function getData(system, assignmentId, count) {
        var withCredentials = system != 'nocookie';
        var params = '?utm_source=toloka-collections-feed&toloka_assignment_id=' + assignmentId + '&after=' + count;

        if (system == 'nocookie') {
            params += '&type=general';
        } else if (system == 'random') {
            params += '&type=random';
        } else if (system == 'major') {
            params += '&type=trash&rec_flags=trash_type=major';
        } else if (system == 'minor') {
            params += '&type=trash&rec_flags=trash_type=minor';
        } else if (system == 'hot') {
            params += '&type=general';
        } else {
            params += system;
        }
        return makeReq(withCredentials, params);
    }

    function makeReq(withCredentials, params) {
        return $.ajax({
            type: 'GET',
            url: 'https://yandex.ru/collections/api/user/feed/anonymous' + params,
            dataType: 'json',
            xhrFields: { withCredentials: withCredentials },
            crossDomain: true,
            cache: false
        });
    }

    function updateUserStats(params, callback) {
        $.ajax({
            type: 'GET',
            url: 'https://yandex.ru/collections/api/user/stats' + params,
            dataType: 'json',
            xhrFields: { withCredentials: true },
            crossDomain: true,
            cache: false
        }).then(function(data) {
            userStats = data;
            if (callback) {
                callback(data);
            }
        });
    }

    function userStatsToUserActions(stats) {
        // actions: [likes, cards, subscriptions]
        return [
            stats.own_likes,
            stats.cards,
            stats.board_subscriptions + stats.channel_subscriptions + stats.user_subscriptions
        ]
    }

    var cardTemplate = null;

    function renderItem(item, idx) {
        if (!item) {
            item = {};
        }
        item['isInvertColorBlack'] = true;
        item['background_color'] = '#758B9A';
        try {
            var color = item.content[0].content.avatars_meta.color_wiz_back;
            item['isInvertColorBlack'] = !isInvertColorBlack(color);
            item['background_color'] = color;
        } catch (err) {}

        item['idx'] = idx + 1;
        return cardTemplate(item);
    }

    exports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function(options) {
        TolokaHandlebarsTaskSuite.call(this, options);
        window.taskSuite = this;
    }, {
        onRender: function() {
            var tasks = this.getTasks();
            this.maxTasks = (tasks !== undefined && tasks && tasks.length) ? tasks.length : 1;

            assignmentId = this.getAssignment().getId() || 'default_assingment_id';
            cardTemplate = Handlebars.compile(itemTemplate);

            updateUserStats(
                '?utm_source=toloka-collections-feed&toloka_assignment_id=' + assignmentId,
                function(stats) {
                    trainInitialUserActions = userStatsToUserActions(stats);
                }
            );

            var $body = $('body');
            $body.on('error', '.image__img', this._onImgError);

            this._initControls();
            this._initTasks();
        },

        _initControls: function() {
            var _this = this;

            Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_total'), function (el) {
                // В каждый таск прописываем кол-во тасков
                el.innerText = _this.maxTasks;
            });

            Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_current'), function (el, idx) {
                // В каждый таск устанавливаем его номер
                el.innerText = idx + 1;
            });

            Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_arrow'), function (el) {
                // Обработчик клика по стрелкам
                return el.addEventListener('click', _this.onTaskArrows.bind(_this));
            });
        },

        _initTasks: function() {
            var _this = this;
            var tasks = _this.getTasks();
            var itemData = tasks[0].getTemplateData();
            var system1_name = itemData.json_input.system1;
            var system2_name = itemData.json_input.system2;

            if (Math.random() >= 0.5) {
                // прямой порядок запросов
                $.when.apply(undefined, [
                        getData(system1_name, assignmentId, (_this.maxTasks-4) * TASKS_PER_PAGE),
                        getData(system2_name, assignmentId, (_this.maxTasks-4) * TASKS_PER_PAGE),
                        getData('random', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('nocookie', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('minor', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('major', assignmentId, 2 * TASKS_PER_PAGE),
                    ])
                    .then(function(system1, system2, hp_random, hp_nocookie, hp_minor, hp_major) {
                        _this._onAjaxLoaded(_this, system1, system2, hp_random, hp_nocookie, hp_minor, hp_major);
                    }, _this._onAjaxError);
            } else {
                $.when.apply(undefined, [
                        getData(system2_name, assignmentId, (_this.maxTasks-4) * TASKS_PER_PAGE),
                        getData(system1_name, assignmentId, (_this.maxTasks-4) * TASKS_PER_PAGE),
                        getData('random', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('nocookie', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('minor', assignmentId, 2 * TASKS_PER_PAGE),
                        getData('major', assignmentId, 2 * TASKS_PER_PAGE),
                    ])
                    .then(function(system2, system1, hp_random, hp_nocookie, hp_minor, hp_major) {
                        _this._onAjaxLoaded(_this, system1, system2, hp_random, hp_nocookie, hp_minor, hp_major);
                    }, _this._onAjaxError);
            }
        },

        _onAjaxError: function(msg) {
            alert(
                'Ошибка запроса за данными :(\n' +
                'Попробуйте обновить страницу через Ctrl+F5 или Ctrl+R\n' +
                'Если не поможет — то в инструкции есть ещё 3 шага, которые помогут загрузить задание\n' +
                'Если и это не поможет — то пишите в поддержку\n' +
                'И приложите скриншот ошибки и консоли как указано в инструкции — это поможет разобраться с проблемой\n' +
                msg
            );
        },

        _onAjaxLoaded: function(_this, system1, system2, hp_random, hp_nocookie, hp_minor, hp_major) {
            var tasks = _this.getTasks();
            var itemData = tasks[0].getTemplateData();
            var system1_cgi = itemData.json_input.system1;
            var system2_cgi = itemData.json_input.system2;

            var allTasks = [];
            system1 = system1[0].results;
            system2 = system2[0].results;
            hp_random = hp_random[0].results;
            hp_nocookie = hp_nocookie[0].results;
            hp_minor = hp_minor[0].results;
            hp_major = hp_major[0].results;

            if (system1.length < 30 || system2.length < 30 || hp_random.length < 12 || hp_nocookie.length < 12 || hp_minor.length < 12 || hp_major.length < 12) {
                // как минимум 6 карточек на таск должно быть.
                _this._onAjaxError([system1.length, system2.length, hp_random.length, hp_nocookie.length, hp_minor.length, hp_major.length]);
                return;
            }

            var systemsCount = [system1.length, system2.length, hp_random.length, hp_nocookie.length, hp_minor.length, hp_major.length].slice();

            for (var i = 0; i < _this.maxTasks - 4; ++i) {
                allTasks.push(shuffle([
                    addKey(getRandomElements(system1, Math.ceil(system1.length / (_this.maxTasks - 4)), true), 'system', system1_cgi),
                    addKey(getRandomElements(system2, Math.ceil(system2.length / (_this.maxTasks - 4)), true), 'system', system2_cgi)
                ]));
            }
            allTasks.push(shuffle([
                addKey(getRandomElements(hp_random, TASKS_PER_PAGE), 'system', 'random'),
                addKey(getRandomElements(hp_minor, TASKS_PER_PAGE), 'system', 'minor')
            ]));
            allTasks.push(shuffle([
                addKey(getRandomElements(hp_random, TASKS_PER_PAGE), 'system', 'random'),
                addKey(getRandomElements(hp_major, TASKS_PER_PAGE), 'system', 'major')
            ]));
            allTasks.push(shuffle([
                addKey(getRandomElements(hp_nocookie, TASKS_PER_PAGE), 'system', 'nocookie'),
                addKey(getRandomElements(hp_minor, TASKS_PER_PAGE), 'system', 'minor')
            ]));
            allTasks.push(shuffle([
                addKey(getRandomElements(hp_nocookie, TASKS_PER_PAGE), 'system', 'nocookie'),
                addKey(getRandomElements(hp_major, TASKS_PER_PAGE), 'system', 'major')
            ]));

            shuffle(allTasks);

            _this.getTasks().forEach(function(task, idx) {
                task.init(allTasks[idx]);
                task.result.systems_count = systemsCount;
            });
        },

        _onImgError: function() {
            var src = this.src;
            if (src.indexOf('retry') === -1) {
                // одна попытка перезагрузить картинку
                this.src += '?retry=' + new Date().getTime();
            }
        },

        onDestroy: function() {
            var $body = $('body');
            $body.off('error', '.image__img');
        },

        onTaskArrows: function(e) {
            var direction = +e.target.dataset.dir;

            setTimeout(function () {
                window.taskSuite.switchTasks(direction);
            }, 200);
        },

        switchTasks: function (direction) {
            var currentTask = this.getFocusedTask() && parseInt(this.getFocusedTask().getTask().id);
            var nextTask = Math.min(Math.max(currentTask + direction, 0), this.maxTasks - 1);

            this.focusTask(nextTask);
        },

        onValidationFail: function (errors) {
            var tasks = this.getTasksIndexed();

            TolokaHandlebarsTaskSuite.prototype.onValidationFail.apply(this, arguments);

            errors.forEach(function (err) {
                if (err) {
                    tasks[err.task_id].getDOMElement().querySelector('.controls').classList.add('controls_error');
                }
            });
        }
    });

    exports.Task = extend(TolokaHandlebarsTask, function(options) {
        TolokaHandlebarsTask.call(this, options);
    }, {

        onRender: function() {
            this.result = {
                cards: [],
                systems_count: []
            };

            this._initTasks();
        },

        init: function(cards) {
            this.result = {
                cards: [],
                systems_count: []
            };

            this.renderCards('.results__left .results__pane', cards[0]);
            this.renderCards('.results__right .results__pane', cards[1]);
            $(this.getDOMElement()).find('.results').show();
        },

        renderCards: function(containerSelector, items) {
            var _this = this;
            var domElem = $(this.getDOMElement());
            var $results = domElem.find(containerSelector);

            var itemsHtml = '';
            items.forEach(function(item, idx) {
                itemsHtml += renderItem(item, idx);
            });
            $results.append($(itemsHtml));

            _this.result.cards.push([]);
            var lastIndex = _this.result.cards.length - 1;
            $results.find('.view').each(function(idx, item) {
                _this.result.cards[lastIndex].push(_this._getCardParams($(item)));
            })
        },

        _getCardParams: function($view) {
            return {
                idx: +$view.data('idx'),
                card_id: $view.data('cardid'),
                system: $view.data('system'),
                card: {
                    img: $view.find('.image__img').attr('src'),
                    title: $view.find('.person__description').text(),
                    descr: $view.find('.view__title').text(),
                    page: $view.find('.view__source').text()
                }
            }
        },

        /**
         * Предварительный фильтр для исходных данных
         * Можно добавить или удалить что-то, что потом отрисуется в шаблоне
         */
        getTemplateData: function() {
            var data = TolokaHandlebarsTask.prototype.getTemplateData.apply(this, arguments);

            // if (data.json_input && data.json_input.type && data.json_input.type === 'training') {
            //     IS_TRAINING = true;
            //     IS_EXAM = false;
            //     IS_TASK = false;
            // } else if (data.json_input && data.json_input.type && data.json_input.type === 'exam') {
            //     IS_TRAINING = false;
            //     IS_EXAM = true;
            //     IS_TASK = false;
            // }

            return data;
        },

        _initTasks: function() {

        },

        // /**
        //  * Обработчик нажатия горячих клавиш
        //  */
        // onKey: function(key) {
        //     var $checkbox = $(this.getDOMElement()).find('.choice__checkbox_idx_' + key + ' input');
        //
        //     if ($checkbox.length > 0) {
        //         $checkbox.click();
        //     }
        // },

        addError: function(message, field, errors) {
            errors || (errors = {
                task_id: this.getOptions().task.id,
                errors: {}
            });
            errors.errors[field] = {
                message: message
            };

            return errors;
        },

        /**
         * Валидация задания
         */
        validate: function(solution) {
            var errors = TolokaHandlebarsTask.prototype.validate.apply(this, arguments);

            var inputs = $(this.getDOMElement()).find('.radio_checked');
            if (!inputs || !inputs.length) {
                errors = this.addError('Выберите какая лента лучше', '__TASK__', errors);
            }

            return errors;
        },
        
        setSolution: function (solution) {
            // TolokaHandlebarsTask.prototype.setSolution.call(this, solution);

            var pane = this.getDOMElement().querySelector('.controls');
            pane.classList.remove('controls_error');

            setTimeout(function () {
                window.taskSuite.switchTasks(+1);
            }, 300);
        },

        /**
         * Формирует результирующий json output
         */
        getSolution: function() {
            var solution = TolokaHandlebarsTask.prototype.getSolution.call(this);

            if (!this.getWorkspaceOptions().isReadOnly) {
                solution.output_values['json_output'] = $.extend(true, {}, this.result);
                solution.output_values['json_output']['assignmentId'] = assignmentId;
                solution.output_values['json_output']['userStats'] = userStats;
                solution.output_values['json_output']['result'] = $('.task_focused').find('.radio_checked input').val();
            }

            // console.info(solution);

            return solution;
        },

        onDestroy: function() {}
    });

    function extend(ParentClass, constructorFunction, prototypeHash) {
        constructorFunction = constructorFunction || function() {};
        prototypeHash = prototypeHash || {};
        if (ParentClass) {
            constructorFunction.prototype = Object.create(ParentClass.prototype);
        }
        for (var i in prototypeHash) {
            constructorFunction.prototype[i] = prototypeHash[i];
        }
        return constructorFunction;
    }

    Handlebars.registerHelper('eq', function () {
        const args = Array.prototype.slice.call(arguments, 0, -1);
        return args.every(function (expression) {
            return args[0] === expression;
        });
    });

}(jQuery));
