!(function($) {

var BASE_COLLECTIONS_URL = 'https://yandex.ru';
// var BASE_COLLECTIONS_URL = 'https://priemka-quality.collections.test.yandex.ru';

if (window.location.href == 'https://localhost:9000/') {
    BASE_COLLECTIONS_URL = 'http://localhost:8686';
}

var CARDS_PER_REQUEST = 24;

var assignmentId = null;
var userStats = {};


var itemTemplate = '' +
'<div class="view" data-cardid="{{id}}" data-pos="{{item_pos}}" data-reason="{{#if (ifeq reason.reason \'reason_1\')}}reason_1__{{reason.channel.slug}}{{else}}{{reason.reason}}{{/if}}" data-system_name="{{system.name}}" data-system_cgi="{{system.cgi}}">' +
    '<div class="view__info">' +
        '<a href="{{url}}" target="_blank" class="view__link">открыть ссылку</a>' +
    '</div>' +
'</div>';

function getData(system, assignmentId, count) {
    var params = '&toloka_assignment_id=' + assignmentId + '&after=' + count;

    if (system == 'random') {
        params += '&type=random';
    } else if (system == 'major') {
        params += '&type=trash&rec_flags=trash_type=major';
    } else if (system == 'minor') {
        params += '&type=trash&rec_flags=trash_type=minor';
    } else if (system == 'hot') {
        params += '&type=general';
    } else {
        params += system;
        // для веба и новостей дополнительно логируем id уникальной страницы таска для толокера
        if (system.indexOf('web_source_params=from=toloka') >= 0) {
            params += ';web_source_params=toloka_assignment_id=' + assignmentId;
        } else if (system.indexOf('%3Bweb_source_params%3Dfrom%3Dtoloka') >= 0) {
            params += '%3Bweb_source_params%3Dtoloka_assignment_id%3D' + assignmentId;
        } else if (system.indexOf('news_source_params=from=toloka') >= 0) {
            params += ';news_source_params=toloka_assignment_id=' + assignmentId
        } else if (system.indexOf('%3Bnews_source_params%3Dfrom%3Dtoloka') >= 0) {
            params += '%3Bnews_source_params%3Dtoloka_assignment_id%3D' + assignmentId;
        }
    }
    return makeReq(system.indexOf('nocookie') === -1, params);
}

function makeReq(withCredentials, params) {
    var headers = {};
    if (BASE_COLLECTIONS_URL.indexOf('yandex.ru') >= 0) {
        headers['X-Yandex-Collections-Toloka'] = '1';
    }
    return $.ajax({
        type: 'GET',
        url: BASE_COLLECTIONS_URL + '/collections/api/user/feed/anonymous' +
            //'?rec_flags=update_history=false' +  // НЕ РАБОТАЕТ!!!
            '?utm_source=toloka-collections-feed' +
            params,
        dataType: 'json',
        xhrFields: { withCredentials: withCredentials },
        headers: headers,
        crossDomain: true,
        cache: false
    });
}

function updateUserStats(params, callback) {
    $.ajax({
        type: 'GET',
        url: BASE_COLLECTIONS_URL + '/collections/api/user/stats' + params,
        dataType: 'json',
        xhrFields: { withCredentials: true },
        crossDomain: true,
        cache: false
    }).then(function(data) {
        userStats = data;
        if (callback) {
            callback(data);
        }
    });
}

var cardTemplate = null;

function deepValue(obj, path){
    path = path.split('.');
    for (var i=0, len=path.length; i < len; i++){
        obj = obj[path[i]];
    }
    return obj;
}

function parseWebItem(item) {
    var result = item;

    var url_field = 'source_meta.page_url';
    if (item.system && item.system.url_field && item.system.url_field.length >= 3) {
        // берём поле с урлом из входных данных
        url_field = item.system.url_field;
    }

    try {
        result.url = deepValue(result, url_field);
    } catch(e) {
        // default value if error
        result.url = 'https://yandex.ru';
    }

    return result;
}

function isObject(obj) {
    return obj === Object(obj) && Object.prototype.toString.call(obj) !== '[object Array]'
}

function isArray(obj){
    return !!obj && obj.constructor === Array;
}

function renderItem(item) {
    if (!item) {
        item = {};
    }

    item = parseWebItem(item);

    // console.info('render item', item);
    return cardTemplate(item);
}

var globalRequests = [];
var globalResults = [];
var tryCount = 0;
function requestNext(callback) {
    if (globalRequests.length) {
        var currentRequests = globalRequests.shift();

        $.when.apply(undefined, _.map(currentRequests, function(requestParams) {
            return getData(requestParams, assignmentId, CARDS_PER_REQUEST);
        }))
        .then(function() {
            // ajax success
            var args = [].slice.call(arguments);
            if (args.length == 3 && args[1] === 'success') {
                // если ajax запрос по одной системе, то формируем "массив"
                args = [args];
            }

            // проверка того, чтобы по всем ajax запросам пришёл непустой массив результатов
            var isAjaxError = false;
            var resultsLength = [];
            args.forEach(function(systemArgs, index) {
                var data = systemArgs[0];
                if (data.results) {
                    if (data.results.length == 0) {
                        isAjaxError = true;
                    }
                    resultsLength[index] = data.results.length;
                } else {
                    isAjaxError = true;
                }
            });

            if (!isAjaxError) {
                // сохраняем результаты, идём дальше
                tryCount = 0;
                globalResults.push(args);
                requestNext(callback);
            } else {
                // ajax error
                _onAjaxErrorLogConsole(this, resultsLength);
                if (tryCount > 5) {
                    _onAjaxError('ajax error, empty results, tryCount: ' + tryCount);
                    return;
                }
                // возвращаем cgi параметры обратно, делаем перезапрос
                globalRequests.unshift(currentRequests);
                ++tryCount;
                requestNext(callback);
            }
        }, function() {
            // ajax error
            _onAjaxErrorLogConsole(this);
            if (tryCount > 3) {
                _onAjaxError('ajax error, tryCount: ' + tryCount, this);
                return;
            }
            // возвращаем cgi параметры обратно, делаем перезапрос
            globalRequests.unshift(currentRequests);
            ++tryCount;
            requestNext(callback);
        });
    } else {
        callback(globalResults);
    }
}

function _onAjaxErrorLogConsole(state, resultsLength) {
    var currentState = state;
    if (isObject(currentState)) {
        currentState = [currentState]
    }
    if (currentState && currentState.length > 0) {
        for (var i = 0; i < currentState.length; ++i) {
            console.log('http error: ' + currentState[i].url.replace(/https?:\/\//,"") + ' => ' +(isArray(resultsLength) ? resultsLength[i] : ''));
        }
    }
}

function _onAjaxError(msg, state) {
    alert(
        'Ошибка запроса за данными :(\n' +
        'Попробуйте обновить страницу через Ctrl+F5 или Ctrl+R\n' +
        'Если не поможет — то в инструкции есть ещё 3 шага, которые помогут загрузить задание\n' +
        'Если и это не поможет — то пишите заказчику Поллукс\n' +
        'И приложите скриншот ошибки и консоли как указано в инструкции — это поможет разобраться с проблемой\n' +
        msg
    );
}

exports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function(options) {
    TolokaHandlebarsTaskSuite.call(this, options);
}, {
    onRender: function() {
        assignmentId = this.getAssignment().getId() || 'default_assingment_id';
        cardTemplate = Handlebars.compile(itemTemplate);

        updateUserStats('?utm_source=toloka-collections-feed&toloka_assignment_id=' + assignmentId);

        var $body = $('body');
        var _this = this;

        this._tasksSystems = [];
        this._dynamicTasksSystems = [];
        this._staticTasksSystems = [];
        this._tasksData = [];

        this._loadTasks();

        $body.on('keydown', function() {
            var task = _this.getFocusedTask();
            task && task._onKey.apply(task, arguments);
        });

    },

    /**
     * Возвращает массив систем с указанием количества карточек в каждой
     */
    _getSystemsCardsCount: function() {
        var results = {};

        _.map(this.getTasks(), function(task) {
            var templateData = task.getTemplateData();
            var taskSource = templateData['json_input'];
            var systemName;

            if (taskSource['type'] == 'hp') {
                systemName = 'hp';
            } else if (taskSource['type'] == 'task_static') {
                systemName = 'task_static';
            } else {
                systemName = taskSource['system']['name'];
            }

            if (!results[systemName]) {
                if (systemName == 'hp') {
                    results[systemName] = {'name': 'hp'}
                } else if (systemName == 'task_static') {
                    results[systemName] = {'name': 'task_static'}
                } else {
                    results[systemName] = _.clone(taskSource['system']);
                    results[systemName]['current_card_index'] = 0;
                }
                results[systemName]['count'] = 0;
            }
            results[systemName]['count'] += 1;
        });

        return _.values(results);
    },

    _parseMainAjaxResults: function(ajaxResults) {
        var results = [];
        for (var step = 0; step < ajaxResults.length; ++step) {
            for (var systemIndex = 0; systemIndex < ajaxResults[step].length; ++systemIndex) {
                results[systemIndex] = (results[systemIndex] || [])
                    .concat(ajaxResults[step][systemIndex][0].results);
            }
        }
        return results;
    },

    /**
     * Загружает задания для основных систем, скачивает параллельно 2 системы
     * последовательно пачками по `CARDS_PER_REQUEST` карточек
     */
    _loadMainSystems: function(mainSystems, callback) {
        var steps = mainSystems[0].count / CARDS_PER_REQUEST;

        globalRequests = [];
        for (var i = 0; i < steps; ++i) {
            globalRequests.push(_.map(mainSystems, function(system) { return system.cgi }));
        }

        requestNext(function(ajaxResults) {
            callback(ajaxResults);
        });
    },

    _initTasks: function() {
        var _this = this;
        // console.log('_tasksSystems', this._tasksSystems, this._tasksData);

        // проверяет ожидаемое и загруженное количество карточек
        for (var i = 0; i < this._dynamicTasksSystems.length; ++i) {
            if (this._dynamicTasksSystems[i].count > this._tasksData[i].length) {
                _onAjaxError('err code 1 ' + i + ' cnt ' + this._dynamicTasksSystems[i].count + ' - ' + this._tasksData[i].length);
                return;
            }
        }

        // инициализируем задания (микротаски)
        this.getTasks().forEach(function(task) {
            var templateData = task.getTemplateData();
            var taskSource = templateData['json_input'];

            if (taskSource['type'] == 'hp' || taskSource['type'] == 'task_static') {
                // если ханипот, то сразу показываем
                task._showCard();
                task._initStaticCard();
                return;
            }

            // для боевых заданий:
            var systemIndex = _.findIndex(_this._dynamicTasksSystems, taskSource['system']);
            var system = _this._dynamicTasksSystems[systemIndex];

            var taskData = _this._tasksData[systemIndex][system.current_card_index];
            taskData['system'] = system;
            taskData['system_name'] = system.name;
            taskData['system_cgi'] = system.cgi;
            taskData['item_pos'] = system.current_card_index;
            ++system.current_card_index;

            task.init(taskData);
        });
    },

    /**
     * Аяксом параллельно загружает карточки тасков и ханипотов
     */
    _loadTasks: function() {
        var _this = this;

        _this._tasksSystems = this._getSystemsCardsCount();
        _this._dynamicTasksSystems = _.filter(_this._tasksSystems, function(system) {
            return system['name'] != 'hp' && system['name'] != 'task_static';
        });
        _this._staticTasksSystems = _.filter(_this._tasksSystems, function(system) {
            return system['name'] == 'hp' || system['name'] == 'task_static';
        });
        _this._tasksData = [];

        // console.log('имеются системы:', _this._tasksSystems, _this._dynamicTasksSystems, _this._staticTasksSystems);

        if (_this._dynamicTasksSystems.length > 0) {
            this._loadMainSystems(_this._dynamicTasksSystems, function(ajaxResults) {
                _this._tasksData = _this._parseMainAjaxResults(ajaxResults);
                _this._initTasks.call(_this);
            });
        } else if (_this._staticTasksSystems.length > 0) {
            this.getTasks().forEach(function(task) {
                task._showCard();
                task._initStaticCard();
            });
        }
    },

    onDestroy: function() {
        var $body = $('body');
        $body.off('click', '.view');
        $body.off('change', '.choice__radio input');

        globalRequests.length = 0;
        globalResults.length = 0;
    }
});

exports.Task = extend(TolokaHandlebarsTask, function(options) {
    TolokaHandlebarsTask.call(this, options);
}, {

    onRender: function() {
        this.$elem = $(this.getDOMElement());
        var $this = this.$elem;
        var _this = this;

        this.result = {
            card: null,
            startTime: 0,
            endTime: 0,
            dwellTime: 0
        };

        this.$elem.find('.choice__checkbox_notloaded .check input').on('change', this._onNotloadedCheckChange);

        this.$elem.find('.choice__radio .radio').on('click', this._onRadioChange);

        this.$elem.on('click', '.view__link', function() {
            // console.log('onlink click', this);
            setTimeout(function() {
                _this._showControls.apply(_this);
            }, 1500);
        });
    },

    init: function(card) {
        this.result = {
            card: card,
            startTime: 0,
            endTime: 0,
            dwellTime: 0
        };

        this.renderCard(card);
    },

    renderCard: function(item) {
        var $wrapper = this.$elem.find('.card_wrapper');
        var $view_card = $(renderItem(item));

        $wrapper.html($view_card);
        // this.$elem.find('.results').css('display', 'inline-block');
    },

    _showControls: function() {
        this.$elem.find('.results').css('display', 'inline-block');
        this.$elem.find('.view__info').append(
            '<div class="view__linktext">' + this.$elem.find('.view__link').attr('href') + '</div>'
        );
        // var $link = this.$elem.find('.view__link');
        // $link.text($link.attr('href'));
    },

    _getCardParams: function($view) {
        return {
            // idx: +$view.data('idx'),
            pos: +$view.data('pos'),
            card_id: $view.data('cardid'),
            reason: $view.data('reason'),
            system_name: $view.data('system_name'),
            system_cgi: $view.data('system_cgi'),
            card: {
                url: $view.find('.view__link').attr('href')
            }
        }
    },

    _getCardView: function() {
        return this.$elem.find('.view');
    },

    _initStaticCard: function() {
        this.result.card = this._getCardParams(this._getCardView());
        // TODO: проставить индекс карточки для ханипотов
    },

    _onNotloadedCheckChange: function(e) {
        var $input = $(e.target);
        var $check = $input.parents('.check');
        var $task = $check.parents('.task');
        var $radios = $task.find('.choice__radio .radio');

        var windowWidth = window.innerWidth
            || document.documentElement.clientWidth
            || document.body.clientWidth;

        setTimeout(function() {
            if ($check.hasClass('check_checked')) {
                $radios.addClass('radio_disabled');
            } else {
                $radios.removeClass('radio_disabled');
            }
        }, 50);
    },

    _onRadioChange: function(e) {},

    /**
     * Обработчик нажатия горячих клавиш
     * Специально override'им родительский метод, чтобы хоткеи обрабатывать в своём _onKey
     */
    onKey: function(key) {
        // TolokaHandlebarsTask.prototype.onKey.apply(this, arguments);
    },

    /*
     * Кастомный обработчик TaskSuite: body.keydown
     */
    _onKey: function(e) {
        // console.info('_onKey', e);
        var $this = this.$elem;

        if ($('.input__input').is(":focus")) {
            // не обрабатываем дальнейшие хоткеи, если вводится текст
            return;
        }

        if (e.key == 'i' || e.key == 'ш') {
            // включаем/выключаем чекбокс "Запрещёнка"
            this.$elem.find('.choice__checkbox_notloaded input').click();
        }

        if (e.originalEvent.key == '+' || e.originalEvent.key == '=') {
            this._selectPlus();
        } else if (e.originalEvent.key == '0') {
            this._selectZero();
        } else if (e.originalEvent.key == '-') {
            this._selectMinus();
        }
    },

    _selectZero: function() {
        this.$elem.find('.choice__radio input[value="0"]').click();
    },

    _selectPlus: function() {
        var selected = +this.$elem.find('.choice__radio .radio_checked').find('input').attr('value');
        if (!selected) {
            selected = 0;
        }
        var newValue = selected + 1;
        var newValueStr = newValue > 0
            ? '+' + newValue
            : '' + newValue;

        this.$elem.find('.choice__radio input[value="'+ newValueStr +'"]').click();
    },

    _selectMinus: function() {
        var selected = +this.$elem.find('.choice__radio .radio_checked').find('input').attr('value');
        if (!selected) {
            selected = 0;
        }
        var newValue = selected - 1;
        var newValueStr = newValue > 0
            ? '+' + newValue
            : '' + newValue;

        this.$elem.find('.choice__radio input[value="'+ newValueStr +'"]').click();
    },

    _showCard: function() {
        this.$elem.find('.card_wrapper .y-spin').remove();
        this.$elem.find('.card_wrapper .view').css('display', 'inline-block');
        // this.$elem.find('.results').css('display', 'inline-block');
    },

    addError: function(message, field, errors) {
        errors || (errors = {
            task_id: this.getOptions().task.id,
            errors: {}
        });
        errors.errors[field] = {
            message: message
        };

        return errors;
    },

    _getCheckedRadioValue: function() {
        return this.$elem.find('.radio_checked input').val();
    },

    _getIsNotloadedChecked: function() {
        if (!this.$elem) {
            // в случае, если this.$elem нет — то не было onRender и инита таска
            // срабатывает в getSoluton при инициализации страницы
            return;
        }
        return this.$elem.find('input[name=notloaded]').is(':checked');
    },

    /**
     * Валидация задания
     */
    validate: function(solution) {
        var errors = TolokaHandlebarsTask.prototype.validate.apply(this, arguments);

        // TODO: проверить, что ссылка кликнута

        var label = this._getCheckedRadioValue();
        var notloaded = this._getIsNotloadedChecked();

        if (!label && !notloaded) {
            errors = this.addError('Выберите оценку карточки', '__TASK__', errors);
        }

        return errors;
    },

    onFocus: function() {
        this.result.startTime = +new Date();
    },

    onBlur: function() {
        this.result.endTime = +new Date();
        this.result.dwellTime += this.result.endTime - this.result.startTime;
    },

    /**
     * Формирует результирующий json output
     */
    getSolution: function() {
        var solution = TolokaHandlebarsTask.prototype.getSolution.call(this);

        if (!this.getWorkspaceOptions().isReadOnly) {
            if (this._getIsNotloadedChecked()) {
                solution.output_values['label'] = 'notloaded';
            }
            solution.output_values['json_output'] = {};

            solution.output_values['json_output']['toloka_task_id'] = this.getTask().id;
            solution.output_values['json_output']['userStats'] = userStats;

            if (this.result) {
                if (this.result.card) {
                    solution.output_values['json_output']['card'] = this.result.card;
                }

                if (this.result.dwellTime) {
                    solution.output_values['json_output']['startTime'] = this.result.startTime;
                    solution.output_values['json_output']['endTime'] = this.result.endTime;
                    solution.output_values['json_output']['dwellTime'] = this.result.dwellTime;
                }
            }
        }

        delete solution.output_values['notloaded'];

        // console.info('getSolution', solution);

        return solution;
    },

    onDestroy: function() {}
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function() {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}

Handlebars.registerHelper('ifeq', function () {
    var args = Array.prototype.slice.call(arguments, 0, -1);
    return args.every(function (expression) {
        return args[0] === expression;
    });
});

}(jQuery));
