exports.Task = extend(TolokaHandlebarsTask, function (options) {
    TolokaHandlebarsTask.call(this, options);
}, {
    onRender: function () {
        this.$elem = $(this.getDOMElement());
        var _this = this;
        this._linkClicked = {
            1: false,
            2: false
        };

        this.$elem.on('mousedown', '.view__link', function(e) {
            if (e.which == 3) {
                return;
            }
            if (e.target.classList.contains('view__link_1')) {
                _this._linkClicked[1] = true;
            } else if (e.target.classList.contains('view__link_2')) {
                _this._linkClicked[2] = true;
            }

            var link = e.target;
            setTimeout(function () {
                $(link).parent().append('<div>' + link.href + '</div>');
            }, 500);

            if (_this._linkClicked[1] && _this._linkClicked[2]) {
                setTimeout(function () {
                    _this.$elem.find('.results').css('display', 'block');
                }, 1500);
            }
        });
    },

    onKey: function() {
        if (this._linkClicked[1] && this._linkClicked[2]) {
            TolokaHandlebarsTask.prototype.onKey.apply(this, arguments);
        }
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {
        };
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
