!(function ($) {

    var BASE_URL = 'https://frontend.vh.yandex.ru';

    if (window.location.href == 'https://localhost:9000/') {
        BASE_URL = 'http://localhost:8686';
    }

    var CARDS_PER_REQUEST = 10;

    var assignmentId = null;
    var requestsData = null;

    var itemTemplate = '' +
        '<div class="stream-card">' +
            '<a class="" href="{{embed_url}}" target="_blank">' +
                '<div class="stream-card__thumb thumb-preview" style="background-image: url(https:{{thumbnail}})"></div>' +
            '</a>' +
            '<div class="stream-card__meta">' +
                '<div class="stream-card__title">{{title}}</div>' +
                '<div class="stream-card__description">{{description}}</div>' +
                '</div>' +
        '</div>';

    function getData(cgiParams) {
        var withCredentials = true;

        if (cgiParams.indexOf('nocookie') >= 0) {
            withCredentials = false
        }

        return makeReq(withCredentials, cgiParams);
    }

    function makeReq(withCredentials, cgiParams) {
        var headers = {};
        return $.ajax({
            type: 'GET',
            url: BASE_URL + '/v23/carousel_videohub.json?from=toloka_feed&toloka_assignment_id=' + assignmentId +
                '&limit=' + (CARDS_PER_REQUEST * 3) + '&offset=0' +
                cgiParams,
            dataType: 'json',
            xhrFields: {withCredentials: withCredentials},
            headers: headers,
            crossDomain: true,
            cache: false
        });
    }


    var cardTemplate = null;

    function deepValue(obj, path) {
        path = path.split('.');
        for (var i = 0, len = path.length; i < len; i++) {
            obj = obj[path[i]];
        }
        return obj;
    }

    function renderItem(item) {
        if (!item) {
            item = {};
        }

        // console.info('render item', item);
        return cardTemplate(item);
    }
    var globalAjaxRequests = [];
    var globalRequests = [];
    var globalResults = [];
    var tryCount = 0;

    function requestNext(callback) {
        if (globalRequests.length) {
            var currentRequests = globalRequests.shift();

            $.when.apply(undefined, _.map(currentRequests, function (requestCgiParams) {
                    var ajaxRequest = getData(requestCgiParams);
                    globalAjaxRequests.push(ajaxRequest);
                    return ajaxRequest;
                }))
                .then(function () {
                    // ajax success
                    var args = [].slice.call(arguments);
                    if (args.length == 3 && args[1] === 'success') {
                        // если ajax запрос по одной системе, то формируем "массив"
                        args = [args];
                    }

                    // проверка того, чтобы по всем ajax запросам пришёл непустой массив результатов
                    var isAjaxError = false;
                    args.forEach(function (systemArgs) {
                        var data = systemArgs[0];
                        if (!data.set || data.set.length == 0) {
                            isAjaxError = true;
                        }
                    });

                    if (!isAjaxError) {
                        // сохраняем результаты, идём дальше
                        tryCount = 0;
                        globalResults.push(args);
                        requestNext(callback);
                    } else {
                        // ajax error
                        if (tryCount > 5) {
                            _onAjaxError('ajax error, empty results, tryCount: ' + tryCount);
                            return;
                        }
                        // возвращаем cgi параметры обратно, делаем перезапрос
                        globalRequests.unshift(currentRequests);
                        ++tryCount;
                        requestNext(callback);
                    }
                }, function () {
                    // ajax error
                    if (tryCount > 3) {
                        _onAjaxError('ajax error, tryCount: ' + tryCount);
                        return;
                    }
                    // возвращаем cgi параметры обратно, делаем перезапрос
                    globalRequests.unshift(currentRequests);
                    ++tryCount;
                    requestNext(callback);
                });
        } else {
            callback(globalResults);
        }
    }

    function _onAjaxError(msg) {
        console.error('Error: ', msg);
        alert(
            'Ошибка запроса за данными :(\n' +
            'Попробуйте обновить страницу через Ctrl+F5 или Ctrl+R\n' +
            'Если не поможет — то в инструкции есть ещё 3 шага, которые помогут загрузить задание\n' +
            'Если и это не поможет — то пишите сообщение заказчику\n' +
            'И приложите скриншот ошибки и консоли как указано в инструкции — это поможет разобраться с проблемой\n' +
            msg
        );
    }

    exports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function (options) {
        TolokaHandlebarsTaskSuite.call(this, options);
    }, {
        onRender: function () {
            assignmentId = this.getAssignment().getId() || 'default_assingment_id';
            cardTemplate = Handlebars.compile(itemTemplate);

            var $body = $('body');
            var _this = this;

            this._tasksSystems = [];
            this._dynamicTasksSystems = [];
            this._staticTasksSystems = [];
            this._tasksData = [];

            this._loadTasks();

            $body.on('keydown', function () {
                var task = _this.getFocusedTask();
                task && task._onKey.apply(task, arguments);
            });

        },

        /**
         * Возвращает массив систем с указанием количества карточек в каждой
         */
        _getSystemsCardsCount: function () {
            var results = {};

            _.map(this.getTasks(), function (task) {
                var templateData = task.getTemplateData();
                var taskSource = templateData['json_input'];
                var systemName;

                if (taskSource['type'] == 'hp') {
                    systemName = 'hp';
                } else if (taskSource['type'] == 'task_static') {
                    systemName = 'task_static';
                } else {
                    systemName = taskSource['system']['name'];
                }

                if (!results[systemName]) {
                    if (systemName == 'hp') {
                        results[systemName] = {'name': 'hp'}
                    } else if (systemName == 'task_static') {
                        results[systemName] = {'name': 'task_static'}
                    } else {
                        results[systemName] = _.clone(taskSource['system']);
                        results[systemName]['current_card_index'] = 0;
                    }
                    results[systemName]['count'] = 0;
                }
                results[systemName]['count'] += 1;
            });

            return _.values(results);
        },

        _parseMainAjaxResults: function (ajaxResults) {
            var results = [];
            for (var step = 0; step < ajaxResults.length; ++step) {
                for (var systemIndex = 0; systemIndex < ajaxResults[step].length; ++systemIndex) {
                    results[systemIndex] = (results[systemIndex] || [])
                        .concat(ajaxResults[step][systemIndex][0].set);
                }
            }
            return results;
        },

        _parseAjaxMetadata: function (ajaxResults) {
            var results = [];
            for (var step = 0; step < ajaxResults.length; ++step) {
                for (var systemIndex = 0; systemIndex < ajaxResults[step].length; ++systemIndex) {
                    var ajaxData = ajaxResults[step][systemIndex][0];
                    var currentRequestInfo = {};
                    if (ajaxData['apphost-reqid']) {
                        currentRequestInfo['apphost-reqid'] = ajaxData['apphost-reqid'];
                    }
                    if (ajaxData['reqid']) {
                        currentRequestInfo['reqid'] = ajaxData['reqid'];
                    }
                    if (ajaxData['user_data'] && ajaxData['user_data']['req_id']) {
                        currentRequestInfo['user_data__req_id'] = ajaxData['user_data']['req_id'];
                    }
                    results.push(currentRequestInfo);
                }
            }
            return results;
        },

        /**
         * Загружает задания для основных систем, скачивает параллельно 2 системы
         * последовательно пачками по `CARDS_PER_REQUEST` карточек
         */
        _loadMainSystems: function (mainSystems, callback) {
            var steps = mainSystems[0].count / CARDS_PER_REQUEST;

            globalRequests = [];
            for (var i = 0; i < steps; ++i) {
                globalRequests.push(_.map(mainSystems, function (system) {
                    return system.cgi
                }));
            }

            requestNext(function (ajaxResults) {
                callback(ajaxResults);
            });
        },

        _initTasks: function () {
            var _this = this;
            // console.log('_tasksSystems', this._tasksSystems, this._tasksData);

            // проверяет ожидаемое и загруженное количество карточек
            for (var i = 0; i < this._dynamicTasksSystems.length; ++i) {
                if (this._dynamicTasksSystems[i].count > this._tasksData[i].length) {
                    _onAjaxError('err code 1 ' + i + ' cnt ' + this._dynamicTasksSystems[i].count + ' - ' + this._tasksData[i].length);
                    return;
                }
            }

            // инициализируем задания (микротаски)
            this.getTasks().forEach(function (task) {
                var templateData = task.getTemplateData();
                var taskSource = templateData['json_input'];

                if (taskSource['type'] == 'hp' || taskSource['type'] == 'task_static') {
                    // если ханипот, то сразу показываем
                    task._showCard();
                    task._initStaticCard();
                    return;
                }

                // для боевых заданий:
                var systemIndex = _.findIndex(_this._dynamicTasksSystems, taskSource['system']);
                var system = _this._dynamicTasksSystems[systemIndex];

                var taskData = _this._tasksData[systemIndex][system.current_card_index];
                taskData['system'] = system;
                taskData['item_pos'] = system.current_card_index;
                ++system.current_card_index;

                // в сериальной карусельке нет embed_url и поля лежат на уровень ниже в includes
                if (!taskData['embed_url']) {
                    if (taskData['includes']) {
                        taskData['title'] = taskData['includes'][0]['title'];
                        taskData['embed_url'] = taskData['includes'][0]['embed_url'];
                        taskData['description'] = taskData['includes'][0]['description'];
                        taskData['ya_video_preview'] = taskData['includes'][0]['ya_video_preview'];
                        taskData['thumbnail'] = taskData['includes'][0]['thumbnail'];
                    }
                }

                if (taskData['content_id']) {
                    taskData['embed_url'] = 'https://yandex.ru/efir?stream_id=' + taskData['content_id'] + '&from_block=toloka_carousel_id';
                }

                task.init(taskData);
            });
        },

        /**
         * Аяксом параллельно загружает карточки тасков и ханипотов
         */
        _loadTasks: function () {
            var _this = this;

            _this._tasksSystems = this._getSystemsCardsCount();
            _this._dynamicTasksSystems = _.filter(_this._tasksSystems, function (system) {
                return system['name'] != 'hp' && system['name'] != 'task_static';
            });
            _this._staticTasksSystems = _.filter(_this._tasksSystems, function (system) {
                return system['name'] == 'hp' || system['name'] == 'task_static';
            });
            _this._tasksData = [];

            // console.log('имеются системы:', _this._tasksSystems, _this._dynamicTasksSystems, _this._staticTasksSystems);

            if (_this._dynamicTasksSystems.length > 0) {
                this._loadMainSystems(_this._dynamicTasksSystems, function (ajaxResults) {
                    _this._tasksData = _this._parseMainAjaxResults(ajaxResults);
                    requestsData = _this._parseAjaxMetadata(ajaxResults);
                    _this._initTasks.call(_this);
                });
            } else if (_this._staticTasksSystems.length > 0) {
                this.getTasks().forEach(function (task) {
                    task._showCard();
                    task._initStaticCard();
                });
            }
        },

        onDestroy: function () {
            globalAjaxRequests.forEach(function(request) {
                request.abort();
            });
            globalAjaxRequests.length = 0;
            globalRequests.length = 0;
            globalResults.length = 0;
        }
    });

    exports.Task = extend(TolokaHandlebarsTask, function (options) {
        TolokaHandlebarsTask.call(this, options);
    }, {

        onRender: function () {
            this.$elem = $(this.getDOMElement());
            var $this = this.$elem;
            var _this = this;

            this.result = {
                card: null,
                startTime: 0,
                endTime: 0,
                dwellTime: 0
            };

        },

        init: function (card) {
            this.result = {
                card: card,
                startTime: 0,
                endTime: 0,
                dwellTime: 0
            };

            this.renderCard(card);

            // console.log('init task', card, this);
        },

        renderCard: function (item) {
            var _this = this;
            var $wrapper = this.$elem.find('.card_wrapper');
            var $view_card = $(renderItem(item));

            $wrapper.html($view_card);
            // this.$elem.find('.results').css('display', 'inline-block');
            (function(){
              var count        = 0,
                  upperBound   = 9,
                  intervalTime = 1000,
                  interval     = setInterval(function(){
                    if (count === upperBound) {
                        clearInterval(interval);
                        _this._showControls();
                    } else {
                        count++;
                    };
                  }, intervalTime);
            }());

            this._loadVideo($wrapper, item.ya_video_preview);

            if (this._isTaskFocused) {
                // для первого задания onFocus срабатывает раньше инита карточки — поэтому сразу проигрываем
                this._startVideo();
            }
        },

        _loadVideo: function(wrapper, video_url) {
            var video = document.createElement('video');
            var isCanPlay = !!video.canPlayType;
            if (!isCanPlay) {
                // если браузер не поддерживает html5 видео, то ничего не делаем
                return;
            }

            this._video = this._initVideo(video, video_url);
            wrapper.find('.thumb-preview').append(this._video);
        },

        _initVideo: function (video, url) {
            video.src = url;
            video.classList.add('thumb-preview__video');
            video.autoplay = true;
            video.muted = true;
            // video.loop = true;
            video.setAttribute('playsinline', 'playsinline');
            video.setAttribute('x-yandex-pip', 'false');
            return video;
        },

        _showControls: function () {
            this.$elem.find('.results').css('display', 'inline-block');
        },

        _getCardParams: function ($view) {
            return {
                system_name: $view.data('system_name'),
                card: {
                    url: $view.find('.stream-card__url').attr('href'),
                    title: $view.find('.stream-card__title').text(),
                    description: $view.find('.stream-card__description').text(),
                    preview: $view.data('preview'),
                    image: $view.find('.stream-card__thumb').css('background-image').split(/"/)[1]
                }
            }
        },

        _getCardView: function () {
            return this.$elem.find('.stream-card');
        },

        _initStaticCard: function () {
            this.result.card = this._getCardParams(this._getCardView());
            // TODO: проставить индекс карточки для ханипотов

            var $wrapper = this.$elem.find('.card_wrapper');
            this._loadVideo($wrapper, this.result.card.card.preview);

            if (this._isTaskFocused) {
                // для первого задания onFocus срабатывает раньше инита карточки — поэтому сразу проигрываем
                this._startVideo();
            }
        },

        /**
         * Обработчик нажатия горячих клавиш
         * Специально override'им родительский метод, чтобы хоткеи обрабатывать в своём _onKey
         */
        onKey: function (key) {
            // TolokaHandlebarsTask.prototype.onKey.apply(this, arguments);
        },

        /*
         * Кастомный обработчик TaskSuite: body.keydown
         */
        _onKey: function (e) {
            // console.info('_onKey', e);
            var $this = this.$elem;

            if (e.originalEvent.key == '+' || e.originalEvent.key == '=') {
                this._selectPlus();
            } else if (e.originalEvent.key == '0') {
                this._selectZero();
            } else if (e.originalEvent.key == '-') {
                this._selectMinus();
            }
        },

        _selectZero: function () {
            this.$elem.find('.choice__radio input[value="0"]').click();
        },

        _selectPlus: function () {
            var selected = +this.$elem.find('.choice__radio .radio_checked').find('input').attr('value');
            if (!selected) {
                selected = 0;
            }
            var newValue = selected + 1;
            var newValueStr = newValue > 0
                ? '+' + newValue
                : '' + newValue;

            this.$elem.find('.choice__radio input[value="' + newValueStr + '"]').click();
        },

        _selectMinus: function () {
            var selected = +this.$elem.find('.choice__radio .radio_checked').find('input').attr('value');
            if (!selected) {
                selected = 0;
            }
            var newValue = selected - 1;
            var newValueStr = newValue > 0
                ? '+' + newValue
                : '' + newValue;

            this.$elem.find('.choice__radio input[value="' + newValueStr + '"]').click();
        },

        _showCard: function () {
            this.$elem.find('.card_wrapper .y-spin').remove();
            this.$elem.find('.card_wrapper .view').css('display', 'inline-block');
            // this.$elem.find('.results').css('display', 'inline-block');
        },

        addError: function (message, field, errors) {
            errors || (errors = {
                task_id: this.getOptions().task.id,
                errors: {}
            });
            errors.errors[field] = {
                message: message
            };

            return errors;
        },

        _getCheckedRadioValue: function () {
            return this.$elem.find('.radio_checked input').val();
        },

        /**
         * Валидация задания
         */
        validate: function (solution) {
            var errors = TolokaHandlebarsTask.prototype.validate.apply(this, arguments);

            var label = this._getCheckedRadioValue();

            if (!label) {
                errors = this.addError('Выберите оценку карточки', '__TASK__', errors);
            }

            return errors;
        },

        onFocus: function () {
            // console.log('task onFocus', this);
            this._isTaskFocused = true;
            this.result.startTime = +new Date();
            this._startVideo();
        },

        onBlur: function () {
            // console.log('task onBlur', this);
            this.result.endTime = +new Date();
            this.result.dwellTime += this.result.endTime - this.result.startTime;
            this._stopVideo();
        },

        _startVideo: function () {
            if (!this._video || this._isPlaying) {
                return;
            }

            var _this = this;
            var playPromise = this._video.play();
            if (typeof playPromise !== 'undefined') {
                if (this._video.readyState < 0) return;
                playPromise.then(function () {
                    _this._playVideo();
                }).catch(function (error) {
                    console.error('Error: ', error)
                });
            } else {
                this._playVideo();
            }
        },

        _playVideo: function () {
            var _this = this;
            this._isPlaying = true;

            this._video.classList.add('thumb-preview__video_active');
            this._video.addEventListener('ended', function () {
                // console.log('on video ended');
                _this._showControls();
                _this._isPlaying = false;
                _this._startVideo();
            });
        },

        _stopVideo: function () {
            this._isPlaying = false;
            this._video.classList.remove('thumb-preview__video_active');
            this._video.pause();
            if (this._video.readyState > 0) {
                this._video.currentTime = 0;
            }
        },

        /**
         * Формирует результирующий json output
         */
        getSolution: function () {
            var solution = TolokaHandlebarsTask.prototype.getSolution.call(this);

            if (!this.getWorkspaceOptions().isReadOnly) {
                solution.output_values['json_output'] = {};

                solution.output_values['json_output']['toloka_task_id'] = this.getTask().id;

                if (this.result) {
                    if (this.result.card) {
                        solution.output_values['json_output']['card'] = this.result.card;
                    }
                    if (requestsData) {
                        solution.output_values['json_output']['requestsData'] = requestsData;
                    }

                    if (this.result.dwellTime) {
                        solution.output_values['json_output']['startTime'] = this.result.startTime;
                        solution.output_values['json_output']['endTime'] = this.result.endTime;
                        solution.output_values['json_output']['dwellTime'] = this.result.dwellTime;
                    }
                }
            }

            // console.info('getSolution', solution);

            return solution;
        },

        onDestroy: function () {
        }
    });

    function extend(ParentClass, constructorFunction, prototypeHash) {
        constructorFunction = constructorFunction || function () {
            };
        prototypeHash = prototypeHash || {};
        if (ParentClass) {
            constructorFunction.prototype = Object.create(ParentClass.prototype);
        }
        for (var i in prototypeHash) {
            constructorFunction.prototype[i] = prototypeHash[i];
        }
        return constructorFunction;
    }

    Handlebars.registerHelper('ifeq', function () {
        var args = Array.prototype.slice.call(arguments, 0, -1);
        return args.every(function (expression) {
            return args[0] === expression;
        });
    });

}(jQuery));
