#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import urllib3
import requests
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

PORT_NUMBER = 8686
BASE_COLLECTIONS_URL = 'https://yandex.ru'


class myHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        if '/collections/api/' in self.path:
            print BASE_COLLECTIONS_URL + self.path
            r = requests.get(BASE_COLLECTIONS_URL + self.path, verify=False)
            data = r.json()
            json_string = json.dumps(data)

            if 'feed/anonymous' in self.path:
                print 'Got data, results: {}'.format(len(data.get('results', [])))

            self.send_response(200)
            self.send_header('Content-type', 'application/json; charset=UTF-8')
            self.send_header('Access-Control-Allow-Origin', 'https://localhost:9000')
            self.send_header('Access-Control-Allow-Credentials', 'true')
            self.end_headers()
            self.wfile.write(json_string)


try:
    urllib3.disable_warnings()
    server = HTTPServer(('', PORT_NUMBER), myHandler)
    print 'Started web on http://localhost:{port}'.format(port=PORT_NUMBER)

    server.serve_forever()

except KeyboardInterrupt:
    print '^C received, shutting down the web server'
    server.socket.close()
