import sys

class ImagesClothesAspects(object):
    weights: {
        "SAME": 1,
        "SIMILAR": 1,
        "RELATED": 0.5,
        "_404": 0,
        "DIFFERENT": 0
    }

    def __init__(self, depth, judged=False):
        self.depth = depth
        self.judged = judged

    def value(self, metric_params):
        final_score = 0.0
        counter = 0

        for result in metric_params.results[:self.depth]:
            if result.get_scale('cv_clothes_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':
                counter += 1
                final_score += weights[result.get_scale('cv_clothes_relevance', 'NOT_JUDGED')]
                if result.get_scale('cv_clothes_relevance', 'NOT_JUDGED') == "RELATED" and result.get_scale('cv_clothes_aspects_res', 'NOT_JUDGED') != 'NOT_JUDGED':
                    res = json.loads(result.get_scale('cv_clothes_aspects_res', 'NOT_JUDGED'))
                    final_score += (sum([1 if res[x] == 'yes' else 0 for x in res])/len(res)) - 0.5
        return final_score / counters
