import sys
import json

RELEVANCE_WEIGHTS = {
    "SAME": 1,
    "SIMILAR": 1,
    "RELATED": 0.5,
    "_404": 0,
    "404_": 0,
    "DIFFERENT": 0,
}
ASPECTS_WEIGHTS = {
    "0": 0.24999663335584246,
    "1": 1.7583176867473322,
    "2": 0.9577113785341449,
    "3": 1.3268307339496586,
    "4": 0.6967029537634203,
    "5": 1.2978920995621768,
    "6": 1.2168814816229006,
    "7": 1.2960256965019525,
    "8": 0.989381715789872,
    "9": 0.191749764994249,
    "10": 0.14513623144902177,
    "11": 0.3446255242614708,
    "12": 0.9008128849697666,
    "13": 1.4157860583131194,
    "14": 1.3951013524449942,
    "15": 0.9577113785341449,
    "16": 0.26947637860464463,
    "17": 0.3168798721744241,
    "18": 1.2281274323877862,
    "19": 0.9577113785341449,
    "20": 0.9577113785341449,
    "21": 0.9577113785341449,
    "22": 0.1980199996818811,
    "23": 0.1355617988943859,
    "24": 0.9577113785341449,
    "25": 0.001172886944799818,
    "26": 0.9577113785341449,
    "27": 0.24936485668470218,
    "28": 0.4532203309667122,
    "29": 1.957760162160545,
    "30": 0.9577113785341449,
    "31": 0.9577113785341449,
    "32": 0.9577113785341449,
    "33": 0.9577113785341449,
    "34": 1.4236263110379384,
    "35": 0.9577113785341449,
    "36": 0.9577113785341449,
    "37": 0.9577113785341449,
    "38": 0.9097113347522987,
    "39": 0.8224440844092713,
    "40": 0.9577113785341449,
    "41": 0.9608422930015292,
    "42": 0.9577113785341449,
    "43": 0.9577113785341449,
    "44": 0.9577113785341449,
    "45": 0.11910901693157216,
    "46": 0.9754367676031049,
    "47": 1.2393887258098464,
    "48": 0.9577113785341449,
    "49": 1.4088884855572674,
    "50": 0.9776402045916069,
    "51": 0.9577113785341449,
    "52": 0.9577113785341449,
    "53": 0.04248630452268443,
    "54": 0.5789526483946579,
    "55": 0.9577113785341449,
    "56": 0.9577113785341449,
    "57": 0.9545804640667607,
    "58": 0.7465709849796942,
    "59": 0.5744966899317844,
    "60": 0.6471040544978385,
    "61": 0.37697023626811815,
    "62": 0.09246673964899428,
    "63": 0.4425826185872968,
    "64": 0.9577113785341449,
    "65": 0.9577113785341449,
    "66": 1.336184823329044,
    "67": 0.28521415356131874,
    "68": 0.9577113785341449,
    "69": 0.9577113785341449,
    "70": 0.9577113785341449,
    "71": 0.3874098319095752,
    "72": 0.8532129858368794,
    "73": 0.9577113785341449,
    "74": 2.02558995240046,
    "75": 1.8163153557567957,
    "76": 0.9577113785341449,
    "77": 0.9577113785341449,
    "78": 0.9577113785341449,
    "79": 0.9577113785341449,
    "80": 0.9577113785341449,
    "81": 0.9577113785341449,
    "82": 0.9577113785341449,
    "83": 1.2369462405184215,
    "84": 0.8266033899580645,
    "85": 1.0657181787625998,
    "86": 0.191749764994249,
    "87": 2.0971966971182723,
    "88": 0.36237947383238983,
    "89": 0.9577113785341449,
    "90": 1.130405125894939,
    "91": 1.1460024099343504,
    "92": 0.7996854566176906,
    "93": 0.8844269267355689,
    "94": 0.9577113785341449,
    "95": 1.262407715682061,
    "96": 0.6581307350895715,
    "97": 0.9577113785341449,
    "98": 0.9577113785341449,
    "99": 0.9577113785341449,
    "100": 1.0529849787740189,
    "101": 1.322906965438254,
    "102": 1.4962053684403533,
    "103": 1.2685502584671489,
    "104": 0.3976865038179282,
    "105": 1.133382844019548,
    "106": 1.5425715261571624,
    "107": 1.3961970384622175,
    "108": 1.5913996538068702,
    "109": 0.3862021360886841,
    "110": 1.42315402751902,
    "111": 0.9577113785341449,
    "112": 1.340529845363762,
    "113": 1.825761932576365,
    "114": 0.9577113785341449,
    "115": 0.9577113785341449,
    "116": 1.4678169937963816,
    "117": 1.6644589667482816,
    "118": 1.383433278402591,
    "119": 1.281223565616241,
    "120": 0.5632429282915157,
    "121": 1.241019431271106,
    "122": 3.0022405650155513,
    "123": 1.2373211705703266,
    "124": 2.5458961471935577,
    "125": 1.0551709425235523,
    "126": 0.48270376712866947,
    "127": 0.6900743235464769,
    "128": 0.9577113785341449,
    "129": 0.5287833629171359,
    "130": 1.297770047951134,
    "131": 0.9577113785341449,
    "132": 0.9577113785341449,
    "133": 0.6143339083233965,
    "134": 0.9577113785341449,
    "135": 0.8885052374483314,
    "136": 0.9577113785341449,
    "137": 0.223432387080451,
    "138": 0.9577113785341449,
    "139": 0.9577113785341449,
    "140": 1.2301855578701866,
    "141": 0.8506234847202981,
    "142": 0.9577113785341449,
    "143": 0.8827509071531691,
    "144": 0.9577113785341449,
    "145": 0.805817260505697,
    "146": 0.9577113785341449,
    "147": 0.9577113785341449,
    "148": 1.553871070223645,
    "149": 0.9790539777028969,
    "150": 0.9577113785341449,
    "151": 0.9577113785341449,
    "152": 0.4027477210778286,
    "153": 1.3536647296835078,
    "154": 0.17013325296986134,
    "155": 0.9577113785341449,
    "156": 0.6247923613294106,
    "157": 0.7901568493485186,
    "158": 0.2444834432703862,
    "159": 1.179353694492489,
    "160": 0.191749764994249,
    "161": 1.3205305656446504,
    "162": 1.404679062110051,
    "163": 0.1017541428331359,
    "164": 0.8237742054795505,
    "165": 1.379152460907887,
    "166": 1.053673568307539,
    "167": 1.0631687533712113,
    "168": 1.673252231253364,
    "169": 0.9577113785341449,
    "170": 1.0017470704649987,
    "171": 0.7090728485076512,
    "172": 0.7534166236811024,
    "173": 0.9577113785341449,
    "174": 1.6186397220810989,
    "175": 1.6492563607859676,
    "176": 1.2064846446620872,
    "177": 0.3870852663351859,
    "178": 0.24672151639531492,
    "179": 1.1187321472784355,
    "180": 0.6291305628371267,
    "181": 0.8593035595100815,
    "182": 0.2913670391431259,
    "183": 0.9577113785341449,
    "color": 0.8803321843292921
}
LABEL_WEIGHTS = {"27": {"0": 0.24999663335584246, "1": 1.7583176867473322, "2": 0.14350333651053934, "3": 1.3268307339496586, "4": 0.6967029537634203, "5": 1.2978920995621768, "6": 1.2168814816229006, "7": 1.2960256965019525, "17": 1.0113678999509759, "18": 1.2281274323877862, "19": 0.14350333651053934, "20": 0.14350333651053934, "21": 0.14350333651053934, "22": 1.1209683528739047, "23": 0.1355617988943859, "24": 0.14350333651053934, "8": 0.14350333651053934, "9": 1.0218614770883223, "10": 0.14350333651053934, "11": 0.14350333651053934, "12": 0.14350333651053934, "13": 1.4157860583131194, "14": 0.14350333651053934, "16": 0.14350333651053934, "color": 1.530052564757315}, "40": {"25": 0.001172886944799818, "26": 0.1496498455262354, "27": 0.24936485668470218, "28": 0.4532203309667122, "29": 1.957760162160545, "161": 1.3205305656446504, "162": 1.404679062110051, "34": 1.4236263110379384, "38": 0.9097113347522987, "39": 0.8224440844092713, "40": 0.1496498455262354, "41": 0.9608422930015292, "175": 1.6492563607859676, "174": 1.6186397220810989, "169": 0.1496498455262354, "170": 0.1496498455262354, "173": 0.1496498455262354, "172": 0.7534166236811024, "171": 0.7090728485076512, "17": 1.5842115958243848, "18": 0.1496498455262354, "19": 0.1496498455262354, "20": 0.1496498455262354, "21": 0.1496498455262354, "22": 0.1496498455262354, "23": 0.1496498455262354, "24": 0.1496498455262354, "8": 1.155470130721685, "9": 0.5181329680350977, "10": 0.1496498455262354, "11": 0.1496498455262354, "12": 1.8240308518718036, "13": 0.1496498455262354, "14": 0.1496498455262354, "16": 1.6353953844516644, "color": 0.7681372293209578}, "43": {"45": 0.11910901693157216, "46": 0.9754367676031049, "47": 1.2393887258098464, "48": 0.0749031877866393, "49": 1.4088884855572674, "50": 0.9776402045916069, "51": 0.0749031877866393, "52": 0.0749031877866393, "53": 0.04248630452268443, "54": 0.5789526483946579, "55": 0.0749031877866393, "56": 0.0749031877866393, "57": 0.9545804640667607, "58": 0.7465709849796942, "59": 0.5744966899317844, "60": 0.6471040544978385, "61": 0.37697023626811815, "62": 0.09246673964899428, "63": 0.4425826185872968, "64": 0.0749031877866393, "65": 0.0749031877866393, "66": 1.336184823329044, "67": 0.28521415356131874, "17": 0.5420057773153106, "18": 0.0749031877866393, "19": 0.0749031877866393, "20": 0.0749031877866393, "21": 0.0749031877866393, "22": 0.0749031877866393, "23": 0.0749031877866393, "24": 0.0749031877866393, "8": 0.0749031877866393, "9": 0.3448185991188303, "10": 0.0749031877866393, "11": 0.0749031877866393, "12": 0.0749031877866393, "13": 0.0749031877866393, "14": 0.0749031877866393, "16": 0.0749031877866393, "color": 0.7516948711877347}, "51": {"153": 1.3536647296835078, "154": 0.17013325296986134, "155": 0.1478098870270948, "71": 0.3874098319095752, "72": 0.8532129858368794, "73": 0.1478098870270948, "74": 2.02558995240046, "75": 1.8163153557567957, "76": 0.1478098870270948, "168": 1.673252231253364, "167": 1.0631687533712113, "166": 1.053673568307539, "17": 1.1448998140347673, "18": 0.8627623915871118, "19": 0.1478098870270948, "20": 0.1478098870270948, "21": 0.1478098870270948, "22": 0.1478098870270948, "23": 0.1478098870270948, "24": 0.1478098870270948, "8": 0.1478098870270948, "9": 0.7400102852529571, "10": 0.1478098870270948, "11": 0.3446255242614708, "12": 0.1478098870270948, "13": 0.5396470773271721, "14": 1.3951013524449942, "16": 1.1312402406369537, "color": 0.2506618328542566}, "31": {"156": 1.350311936721304, "157": 0.7901568493485186, "158": 0.2444834432703862, "159": 1.179353694492489, "160": 1.8970492932154597, "83": 1.2369462405184215, "84": 0.8266033899580645, "85": 1.0657181787625998, "165": 1.379152460907887, "86": 0.08214670478414147, "87": 2.0971966971182723, "88": 0.36237947383238983, "89": 0.21155383505653239, "90": 1.130405125894939, "91": 1.1460024099343504, "176": 1.2064846446620872, "177": 0.21155383505653239, "179": 1.1187321472784355, "178": 0.24672151639531492, "180": 1.3719531449250748, "17": 2.0898507918035945, "18": 1.9392300985263076, "19": 0.21155383505653239, "20": 0.21155383505653239, "21": 0.21155383505653239, "22": 0.26757259892186913, "23": 0.21155383505653239, "24": 0.21155383505653239, "8": 0.21155383505653239, "9": 1.7404289863819908, "10": 0.21155383505653239, "11": 0.21155383505653239, "12": 0.8308436031330394, "13": 2.035839511879884, "14": 1.2575929965879573, "16": 1.5705963088858852, "color": 1.2330216953738198}, "53": {"156": 0.6247923613294106, "157": 0.01490313952308131, "158": 0.01490313952308131, "159": 0.01490313952308131, "160": 0.191749764994249, "83": 0.01490313952308131, "84": 0.01490313952308131, "85": 0.01490313952308131, "165": 0.01490313952308131, "86": 0.191749764994249, "87": 0.01490313952308131, "88": 0.01490313952308131, "89": 0.01490313952308131, "90": 0.01490313952308131, "91": 0.01490313952308131, "176": 0.01490313952308131, "177": 0.01490313952308131, "179": 0.01490313952308131, "178": 0.01490313952308131, "180": 0.6291305628371267, "17": 0.3168798721744241, "18": 0.01490313952308131, "19": 0.01490313952308131, "20": 0.01490313952308131, "21": 0.01490313952308131, "22": 0.01490313952308131, "23": 0.01490313952308131, "24": 0.01490313952308131, "8": 0.01490313952308131, "9": 0.191749764994249, "10": 0.01490313952308131, "11": 0.01490313952308131, "12": 0.01490313952308131, "13": 0.01490313952308131, "14": 0.01490313952308131, "16": 0.01490313952308131, "color": 0.578035540010114}, "54": {"92": 0.7996854566176906, "93": 0.8844269267355689, "94": 0.15740698642604967, "95": 1.262407715682061, "96": 0.6581307350895715, "97": 0.15740698642604967, "98": 0.15740698642604967, "99": 0.15740698642604967, "100": 1.0529849787740189, "101": 1.322906965438254, "163": 0.1017541428331359, "102": 1.4962053684403533, "164": 0.8237742054795505, "103": 1.2685502584671489, "104": 0.3976865038179282, "105": 1.133382844019548, "106": 1.5425715261571624, "107": 1.3961970384622175, "108": 1.5913996538068702, "109": 0.3862021360886841, "110": 1.42315402751902, "181": 0.8593035595100815, "182": 0.2913670391431259, "17": 0.2719771778313386, "18": 1.4955595020531922, "19": 0.15740698642604967, "20": 0.15740698642604967, "21": 0.15740698642604967, "22": 0.12157684156119943, "23": 0.15740698642604967, "24": 0.15740698642604967, "8": 0.15740698642604967, "9": 2.0976851879467495, "10": 0.15740698642604967, "11": 0.15740698642604967, "12": 0.556215451228673, "13": 0.15740698642604967, "14": 0.15740698642604967, "16": 1.3203846397606027, "color": 0.608745269905116}, "29": {"112": 1.340529845363762, "113": 1.825761932576365, "114": 0.17088901697736414, "115": 0.17088901697736414, "116": 1.4678169937963816, "117": 1.6644589667482816, "118": 1.383433278402591, "119": 1.281223565616241, "120": 0.5632429282915157, "121": 1.241019431271106, "122": 3.0022405650155513, "123": 1.2373211705703266, "124": 2.5458961471935577, "125": 1.0551709425235523, "126": 0.48270376712866947, "127": 0.6900743235464769, "128": 0.17088901697736414, "129": 0.5287833629171359, "130": 1.297770047951134, "17": 0.3340658402500116, "18": 0.17088901697736414, "19": 0.17088901697736414, "20": 0.17088901697736414, "21": 0.17088901697736414, "22": 0.17088901697736414, "23": 0.17088901697736414, "24": 0.17088901697736414, "8": 0.17088901697736414, "9": 1.9829492676683211, "10": 0.17088901697736414, "11": 0.17088901697736414, "12": 0.17088901697736414, "13": 0.17088901697736414, "14": 0.17088901697736414, "16": 0.17088901697736414, "color": 1.6957314513935446}, "37": {"131": 0.06434390148625978, "132": 0.06434390148625978, "133": 0.6143339083233965, "134": 0.06434390148625978, "135": 0.8885052374483314, "136": 0.06434390148625978, "137": 0.223432387080451, "138": 0.06434390148625978, "139": 0.06434390148625978, "140": 1.2301855578701866, "141": 0.8506234847202981, "142": 0.06434390148625978, "143": 0.8827509071531691, "144": 0.06434390148625978, "145": 0.805817260505697, "183": 0.06434390148625978, "147": 0.06434390148625978, "17": 0.37497808080938044, "18": 0.06434390148625978, "19": 0.06434390148625978, "20": 0.06434390148625978, "21": 0.06434390148625978, "22": 0.06434390148625978, "23": 0.06434390148625978, "24": 0.06434390148625978, "8": 0.989381715789872, "9": 0.7325735715157417, "10": 0.06434390148625978, "11": 0.06434390148625978, "12": 0.9008128849697666, "13": 0.06434390148625978, "14": 0.06434390148625978, "16": 0.06434390148625978, "color": 1.2259768819983965}, "48": {"148": 1.553871070223645, "149": 0.9790539777028969, "150": 0.04051391842012972, "151": 0.04051391842012972, "152": 0.4027477210778286, "17": 0.04051391842012972, "18": 0.04051391842012972, "19": 0.04051391842012972, "20": 0.04051391842012972, "21": 0.04051391842012972, "22": 0.1980199996818811, "23": 0.04051391842012972, "24": 0.04051391842012972, "8": 0.04051391842012972, "9": 0.04051391842012972, "10": 0.04051391842012972, "11": 0.04051391842012972, "12": 0.04051391842012972, "13": 0.04051391842012972, "14": 0.04051391842012972, "16": 0.26947637860464463, "color": 0.16126450649166457}}
NOT_JUDGED_WEIGHT = -10
MAX_RELEVANT_WEIGHT = 0.9
MIN_RELEVANT_WEIGHT = 0.1


class ImagesInteriorAspects(object):

    def __init__(self, depth):
        self.depth = depth
        self.weights = RELEVANCE_WEIGHTS

    def value_by_position(self, position_metric_params):
        result = position_metric_params.result
        if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':

            final_score = self.weights[result.get_scale('cv_interior_relevance', 'NOT_JUDGED')]
            if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "RELATED" \
                    and result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED') != 'NOT_JUDGED':

                res = json.loads(result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED'))
                summa = int(sum([1 if res[x] == 'yes' else 0 for x in res]))
                full = int(sum([1 if (res[x] == 'yes' or res[x] == 'no') else 0 for x in res]))
                if full > 0:
                    return final_score + (MAX_RELEVANT_WEIGHT - self.weights['RELATED']) * (summa / full)
            else:
                return final_score
        return NOT_JUDGED_WEIGHT

    def aggregate_by_position(self, agg_metric_params):
        values = [x.value for x in agg_metric_params.pos_metric_values[:self.depth] if x.value != NOT_JUDGED_WEIGHT]
        if len(values) > 0:
            return sum(values) / len(values)
        return None


class ImagesInteriorAspectsCommon(object):

    def __init__(self, depth):
        self.depth = depth
        self.weights = RELEVANCE_WEIGHTS

    def value_by_position(self, position_metric_params):
        result = position_metric_params.result
        if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':
            if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "RELATED" \
                    and result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED') != 'NOT_JUDGED':
                res = json.loads(result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED'))
                n_aspects = int(sum([1 if (res[x] == 'yes' or res[x] == 'no') else 0 for x in res]))
                if n_aspects:
                    return int(sum([1 if res[x] == 'yes' else 0 for x in res])) / n_aspects
        return NOT_JUDGED_WEIGHT

    def aggregate_by_position(self, agg_metric_params):
        values = [x.value for x in agg_metric_params.pos_metric_values[:self.depth] if x.value != NOT_JUDGED_WEIGHT]
        if len(values):
            return sum(values) / len(values)
        return None


class ImagesInteriorComplex(object):

    def __init__(self, depth, lin_decay=0):
        self.depth = depth
        self.relevance_weights = RELEVANCE_WEIGHTS
        self.numeric_weights = ASPECTS_WEIGHTS
        self.lin_decay = lin_decay

    def value_by_position(self, position_metric_params):
        result = position_metric_params.result

        if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':
            final_score = self.relevance_weights[result.get_scale('cv_interior_relevance', 'NOT_JUDGED')]

            if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "RELATED" \
                    and result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED') != 'NOT_JUDGED' \
                    and result.get_scale('cv_interior_color', 'NOT_JUDGED') != 'NOT_JUDGED':

                res = json.loads(result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED'))

                color = float(result.get_scale('cv_interior_color', 'NOT_JUDGED')) * self.numeric_weights['color']
                values_plural = [self.numeric_weights[str(x)] for x in res if res[x] == 'yes']
                values_plural.append(color)

                values_negative = [-1 * self.numeric_weights[str(x)] for x in res if res[x] == 'no']
                values = values_plural + values_negative
                values.append(self.numeric_weights['color'])

                if len(values):
                    max_sum = sum(values_plural) + (-1) * sum(values_negative)
                    metric_value = final_score + (sum(values) / max_sum) * (MAX_RELEVANT_WEIGHT - final_score)
                    return metric_value

            elif result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "SAME" \
                    and result.get_scale('cv_interior_color', 'NOT_JUDGED') != 'NOT_JUDGED':
                color = (1 - float(result.get_scale('cv_interior_color', 'NOT_JUDGED'))) \
                        * self.numeric_weights['color'] / 7
                return max(final_score - color, 0.9)
            else:
                return final_score
        return NOT_JUDGED_WEIGHT

    def aggregate_by_position(self, agg_metric_params):
        values = [x.value for x in agg_metric_params.pos_metric_values[:self.depth] if x.value != NOT_JUDGED_WEIGHT]
        if self.lin_decay > 0:
            weights = [max(1.0 - i * self.lin_decay, 0.0) for i in range(self.depth)]
            marks = [w * x for (w, x) in zip(weights, values)]
            return sum(marks) / sum(weights)
        elif len(values):
            return sum(values) / len(values)
        return None


class JudgedInteriorColor(object):

    def __init__(self, depth):
        self.depth = depth

    def value_by_position(self, position_metric_params):
        result = position_metric_params.result
        if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':
            if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "RELATED" or result.get_scale(
                    'cv_interior_relevance', 'NOT_JUDGED') == "SAME":
                if result.get_scale('cv_interior_color', 'NOT_JUDGED') != 'NOT_JUDGED':
                    return float(result.get_scale('cv_interior_color', 'NOT_JUDGED'))
        return NOT_JUDGED_WEIGHT

    def aggregate_by_position(self, agg_metric_params):
        values = [x.value for x in agg_metric_params.pos_metric_values[:self.depth] if x.value != NOT_JUDGED_WEIGHT]
        if len(values):
            return sum(values) / len(values)
        return None


class ImagesInteriorComplexLabel(object):

    def __init__(self, depth, lin_decay=0):
        self.depth = depth
        self.relevance_weights = RELEVANCE_WEIGHTS
        self.numeric_weights = LABEL_WEIGHTS
        self.lin_decay = lin_decay

    def value_by_position(self, position_metric_params):
        label = position_metric_params.serp_data.get("texts.labels")[0]
        result = position_metric_params.result

        if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') != 'NOT_JUDGED':
            final_score = self.relevance_weights[result.get_scale('cv_interior_relevance', 'NOT_JUDGED')]

            if result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "RELATED" \
                    and result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED') != 'NOT_JUDGED' \
                    and result.get_scale('cv_interior_color', 'NOT_JUDGED') != 'NOT_JUDGED':
                if label and str(label) in self.numeric_weights:
                    label_weights = self.numeric_weights[str(label)]
                    res = json.loads(result.get_scale('cv_interior_aspects_res', 'NOT_JUDGED'))
                    color = float(result.get_scale('cv_interior_color', 'NOT_JUDGED')) * label_weights['color']
                    values_plural = [label_weights[str(x)] for x in res if res[x] == 'yes']
                    values_plural.append(color)
 
                    values_negative = [-1 * label_weights[str(x)] for x in res if res[x] == 'no']
                    values = values_plural + values_negative
                    values.append(label_weights['color'])
    
                    if len(values):
                        max_sum = sum(values_plural) + (-1) * sum(values_negative)
                        metric_value = final_score + (sum(values) / max_sum) * (MAX_RELEVANT_WEIGHT - final_score)
                        return metric_value
                else:
                    return final_score

            elif result.get_scale('cv_interior_relevance', 'NOT_JUDGED') == "SAME" \
                    and result.get_scale('cv_interior_color', 'NOT_JUDGED') != 'NOT_JUDGED':
                color = (1 - float(result.get_scale('cv_interior_color', 'NOT_JUDGED'))) \
                        * ASPECTS_WEIGHTS['color'] / 7
                return max(final_score - color, 0.9)
            else:
                return final_score
        return NOT_JUDGED_WEIGHT

    def aggregate_by_position(self, agg_metric_params):
        values = [x.value for x in agg_metric_params.pos_metric_values[:self.depth] if x.value != NOT_JUDGED_WEIGHT]
        if self.lin_decay > 0:
            weights = [max(1.0 - i * self.lin_decay, 0.0) for i in range(self.depth)]
            marks = [w * x for (w, x) in zip(weights, values)]
            return sum(marks) / sum(weights)
        elif len(values):
            return sum(values) / len(values)
        return None
