from itertools import combinations
from collections import defaultdict

def extract_duplicate_pairs_from_serp(data):
    out_data = []

    for serp in data:
        if 'components' not in serp or 'query' not in serp:
            continue

        for (i1, comp1), (i2, comp2) in combinations(enumerate(serp['components'][:10]), 2):
            if 'judgements.images_duplicates_for_sbs' not in comp1 or 'judgements.images_duplicates_for_sbs' not in comp2:
                continue

            dups_sym = comp1['judgements.images_duplicates_for_sbs']['name'][i2]
            if dups_sym != '1':
                continue

            if 'url.MIMCA_URL' not in comp1 or 'url.MIMCA_URL' not in comp2:
                continue

            if 'long.MIMCA_CRC64' not in comp1 or 'long.MIMCA_CRC64' not in comp2:
                continue

            out_data.append({"elem1": {'image_crc_long': comp1['long.MIMCA_CRC64'], 'image_url': comp1['url.MIMCA_URL']},
                            "elem2": {'image_crc_long': comp2['long.MIMCA_CRC64'], 'image_url': comp2['url.MIMCA_URL']},
                            "duplicates_mark": "DUPLICATES"})

    return out_data


def extract_duplicate_pairs_from_cbir_pairs(data):
    query_dict = defaultdict(list)

    for elem in data:
        if elem['duplicates_mark'] == 'DUPLICATES':
            query_dict[elem['query_url']].append(elem)

    out_data = []

    for query_url, elems_arr in query_dict.items():
        if len(elems_arr) < 2:
            continue

        for elem1, elem2 in combinations(elems_arr, 2):
            out_data.append({'elem1': elem1, 'elem2': elem2})

    return out_data
