import sys
import json

def parse_scraper_serp_factors(data):
    results = list()
    stats = {'ok': 0, 'missed': 0}
    print >>sys.stderr, "Total serps", len(data)

    for serpset in data:
        query = serpset["serp-request-explained"]["per-query-parameters"]["query-text"]
        region_id = serpset["serp-request-explained"]["per-query-parameters"]["region-id"]
        iso_country = serpset["serp-request-explained"]["per-query-parameters"]["iso-country"]
        user_agent_type = serpset["serp-request-explained"]["per-query-parameters"]["user-agent-type"]

        try:
            if serpset["serp-page"] == None or serpset["serp-page"]["parser-results"] == None:
                print >> sys.stderr, "Empty serp for query '{0}'".format(query.encode('utf8'))
                continue
            debug_data = serpset["serp-page"]["parser-results"]["debug-info"]
            props = debug_data["properties"]["UPPER"]

            factors = props.get('ApplyImagesBlender.factors', '')
            dynamic_factors = props.get('ApplyImagesBlender.dynamic_factors', '')

            reqparam = debug_data.get('reqparam', {})

            bgfactors = ''
            if 'relev' in reqparam and len(reqparam['relev']) > 0:
                relev_params = reqparam['relev'][0].split(';')
                for p in relev_params:
                    if '=' not in p:
                        continue
                    param_name, param_value = p.split('=', 1)

                    if param_name == 'bgfactors':
                        bgfactors = param_value
                        break

            query_rt_factors = ''
            if 'rearr' in reqparam and len(reqparam['rearr']) > 0:
                rearr_params = reqparam['rearr'][0].split(';')
                for p in rearr_params:
                    if '=' not in p:
                        continue
                    param_name, param_value = p.split('=', 1)

                    if param_name == 'query_rt_factors':
                        query_rt_factors = param_value
                        break

            if factors or dynamic_factors or bgfactors or query_rt_factors:
                out_elem = {'query_text': query,
                            'query_region_id': region_id,
                            'iso_country': iso_country,
                            'user_agent_type': user_agent_type,
                            'factors': factors,
                            'dynamic_factors': dynamic_factors,
                            'bgfactors': bgfactors,
                            'query_rt_factors': query_rt_factors
                            }
                results.append(out_elem)
            stats['ok'] += 1
        except Exception as e:
            stats['missed'] += 1
            print >> sys.stderr, "Error while parsing answer for query '{0}'!".format(query.encode('utf8'))
            print >>sys.stderr, str(e)

    print >>sys.stderr, "Stats:"
    print >>sys.stderr, json.dumps(stats, indent=2)

    return results
