#!/usr/bin/env python
# coding: utf-8


import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import random
import numpy as np
import itertools
from collections import defaultdict

from swiss import Url, Game, Tournament
from helpers import doc_key, query_key, aggregate_round_results


def calc_dbd_score(url):
    return (url.points_won * 5000 +  # 1) points won
            url.get_buchholz_coef() * 200 +  # 2) Buchholz coef
            int(url.metric * 50))  # 3) metric score


def main(*args):
    queries_grouped, toloka_data, in3, token, any_param, html_file = args

    max_rounds = 0
    toloka_agg = {}
    for task in toloka_data:
        swiss_round = task['round']
        max_rounds = max(max_rounds, swiss_round)
        if swiss_round not in toloka_agg:
            toloka_agg[swiss_round] = defaultdict(list)
        toloka_agg[swiss_round][  query_key(task['inputValues'])  ].append(task)

    pairs_all_queries_correct = 0
    pairs_all_queries_total = 0

    similarity = {}

    idx = -1
    for group in queries_grouped:
        idx += 1
        query = group[0]['query'].decode('utf-8')
        region_id = group[0]['region_id']
        similarity[query] = {}

        urls = {doc_key(item): Url(item, i) for i, item in enumerate(group)}
        urls2 = {doc_key(item): Url(item, i) for i, item in enumerate(group)}

        #print '\n\n============================================================'
        print '{}) Query: {}, region {}, items {} ({})'.format(idx, query.decode('utf-8'), region_id, len(group), '>16' if len(group) > 16 else '<=16')

        # Создаём турнир
        t = Tournament()
        t.set_urls(urls.values())
        t2 = Tournament()
        t2.set_urls(urls2.values())

        games = []
        games2 = []

        for swiss_round in range(1, max_rounds + 1):
            if len(toloka_agg[swiss_round][  query_key(group[0])  ]) == 0:
                continue
            games_played, wins = aggregate_round_results(toloka_agg[swiss_round][  query_key(group[0])  ])

            # Создаём игры текущего раунда
            for i, (left_key, right_key) in enumerate(games_played.keys()):
                game = Game(urls[left_key], urls[right_key])
                game.add_score(wins[left_key], wins[right_key])
                game.round = swiss_round
                game.id = i
                games.append(game)

            # print 'Round {}, games played {}'.format(swiss_round, len(games_played))
            t.set_games(games)

            if swiss_round >= 2:
                sorted_by_dbd_next = Tournament.sort_urls(t.urls, calc_dbd_score)
                sorted_by_dbd_prev = Tournament.sort_urls(t2.urls, calc_dbd_score)

                pairs_count = 0
                correct_pairs = 0
                for pair in itertools.combinations(sorted_by_dbd_next, r=2):
                    if sorted_by_dbd_prev.index(pair[0]) < sorted_by_dbd_prev.index(pair[1]):
                        correct_pairs += 1
                    pairs_count += 1
                similarity[query][swiss_round] = float(correct_pairs) / pairs_count * 100
                # print 'Round {}, correct {} / {} = {:.2f}%'.format(swiss_round, correct_pairs, pairs_count, float(correct_pairs) / pairs_count * 100)

            # Создаём игры текущего раунда
            for i, (left_key, right_key) in enumerate(games_played.keys()):
                game = Game(urls2[left_key], urls2[right_key])
                game.add_score(wins[left_key], wins[right_key])
                game.round = swiss_round
                game.id = i
                games2.append(game)

            t2.set_games(games2)

    rounds = [0 for x in range(1, max_rounds + 2)]
    idx = -1
    for query in similarity.values():
        idx += 1
        for round, sim in query.items():
            rounds[round] += (sim - rounds[round])/(idx + 1)

    print [100 - x for x in rounds]


    return [100 - x for x in rounds]
