#!/usr/bin/env python
# coding: utf-8


import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import random
import numpy as np
from collections import defaultdict

from swiss import Url, Game, Tournament
from helpers import doc_key, query_key, aggregate_round_results, upload_file_to_hurge, get_html_queries


def main(*args):
    queries_grouped, toloka_data, sampled_queries, token, any_param, html = args

    SEED = 30
    random.seed(SEED)
    np.random.seed(SEED)
    np.set_printoptions(linewidth=240)
    np.set_printoptions(threshold=np.inf)

    with open('static_header.html') as f:
        html.write(f.read())

    max_rounds = 0
    toloka_agg = {}
    for task in toloka_data:
        swiss_round = task['round']
        max_rounds = max(max_rounds, swiss_round)
        if swiss_round not in toloka_agg:
            toloka_agg[swiss_round] = defaultdict(list)
        toloka_agg[swiss_round][  query_key(task['inputValues'])  ].append(task)

    html.write('<div class="rounds">\n')
    for i in range(1, max_rounds+1):
        html.write('<div class="round round_{i} {selected}" data-round="{i}">Раунд {i}</div>'.format(i=i, selected='round_selected' if i == max_rounds else ''))
    html.write('</div>\n\n')

    # only random queries
    html_queries, sampled_queries_list = get_html_queries([], toloka_agg, queries_divider=30, add_random=True)
    html.write(html_queries)

    new_pairs = []
    html.write('<div class="results">\n')
    idx = -1
    for group in queries_grouped:
        idx += 1
        query = group[0]['query']
        region_id = group[0]['region_id']
        if len(group) % 2 == 1:
            group.pop()

        url_objects = [Url(item, i) for i, item in enumerate(group)]
        urls = {doc_key(url.data): url for url in url_objects}

        #print '\n\n============================================================'
        print '{}) Query: {}, region {}, max_rounds: {}'.format(idx, query.decode('utf-8'), region_id, max_rounds)

        # Создаём турнир
        t = Tournament(html)
        t.set_urls(url_objects)

        # if max_rounds > 0:
        if 2 + 2 == 4:
            games = []

            for swiss_round in range(1, max_rounds + 1):
                games_played, wins = aggregate_round_results(toloka_agg[swiss_round][  query_key(group[0])  ])

                # Создаём игры текущего раунда
                for i, (left_key, right_key) in enumerate(games_played.keys()):
                    game = Game(urls[left_key], urls[right_key])
                    game.add_score(wins[left_key], wins[right_key])
                    game.round = swiss_round
                    game.id = i
                    games.append(game)

                #print 'Round {}'.format(swiss_round)
                t.set_games(games)

                if query in sampled_queries_list:
                    html.write('<div class="results__item" data-query="{q}" data-region="{region}" data-round="{r}">\n'.format(
                        q=query.decode('utf-8'),
                        region=region_id,
                        r=swiss_round
                    ))
                    html.write('<h4>Round: "{r}", Query: "{q}", Region: {region}</h4>\n'.format(
                        q=query.decode('utf-8'),
                        region=region_id,
                        r=swiss_round
                    ))

                    html.write('<pre class="result">\n')
                    html.write(t.print_net(to_stdout=False))
                    html.write('</pre>\n\n')

                    html.write('<hr>')
                    html.write('<p>Sort by <span class="sorter" data-sortby="relevance">Relevance</span> <span class="sorter" data-sortby="metric3cg">3CG</span> <span class="sorter" data-sortby="corsa">Corsa</span> <span class="sorter sorter__active" data-sortby="score">DbD</span></p>')
                    html.write('<div class="gallery">\n')
                    html.write(t.print_gallery())
                    html.write('</div>\n\n')
                    html.write('</div>\n\n')

            new_games = t.build_round(is_swiss=True)
        else:
            # 1-й раунд
            # t.print_net()
            new_games = t.build_round(is_swiss=False)
        new_pairs += [x.toJSON() for x in new_games]

    html.write('</div>\n\n')

    # print 'Hurge url to html results: {}'.format(upload_file_to_hurge('index.html'))
    return new_pairs

