#!/usr/bin/env python
# coding: utf-8

import os
import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import json
import copy
import math
import random
import datetime
import numpy as np
import functools
from pprint import pprint
import multiprocessing
from multiprocessing.dummy import Pool
from collections import defaultdict, OrderedDict

from helpers import aggregate_toloka_data, play_tournament_games, get_boosts_metrics_structure, get_boost_metrics_structure
from helpers import get_sorters_html, get_html_table_header, get_html_queries
from helpers import boost_3cg, boost_corsa, boost_corsax, boost_corsax_viewport2, boost_utility1, \
    boost_utility_clickopt1_without_rel04

STRONG_PAIRS_THR = 100


def calc_dbd_score(url):
    return (url.points_won * 5000 +  # 1) points won
            url.get_buchholz_coef() * 200 +  # 2) Buchholz coef
            int(url.metric * 50))  # 3) metric score

def calc_pscore(url):
    return url.data['pscore']

def calc_click_boost(url):
    return url.data['click_boost']

def boost_relevance(url):
    return url.data['relevance']

def boost_calc_3cg(url):
    return boost_3cg(url.data)

def boost_corsa1(url):
    return boost_corsa(url.data)

def boost_utility(url):
    return boost_utility1(url.data)

def boost_utility_clickopt_without_rel04(url):
    return boost_utility_clickopt1_without_rel04(url.data)

def boost_corsax_1(url, rel_minus_weight=0.75, boost_weight=0.3):
    return boost_corsax(url.data, rel_minus_weight, boost_weight)

def boost_corsax_1_viewport2(url, rel_minus_weight=0.75, boost_weight=0.3):
    return boost_corsax_viewport2(url.data, rel_minus_weight, boost_weight)


boost_types = OrderedDict([
    ('relevance', boost_relevance),
    ('3cg', boost_calc_3cg),
    ('corsa', boost_corsa1),
    ('corsax_1', boost_corsax_1),
    ('corsax_1_viewport2', boost_corsax_1_viewport2),
    ('click_boost', calc_click_boost),
    ('utility_opt', boost_utility),
    ('utility_clickopt', boost_utility_clickopt_without_rel04),
    ('dbd', calc_dbd_score)
])

targets = OrderedDict([
    ('click_boost', calc_click_boost),
    ('dbd', calc_dbd_score),
])


def calc_query_metrics(group, toloka_agg, sampled_queries_list):
    html = ''
    query = group[0]['query'].decode('utf-8')
    region_id = group[0]['region_id']
    if not toloka_agg[1][(query, region_id)]:
        # тестируем на семпле запросов
        return None, None

    t = play_tournament_games(group, toloka_agg)

    print 'Query: {:<40} region {:<5} items {}'.format(query.decode('utf-8'), region_id, len(group))

    html += get_html_table_header()

    items = t.sort_urls(t.urls, calc_dbd_score, return_as_is=True)
    scores = [x[1] for x in items]
    games_won = [x.games_won for x in t.urls]
    points_won = [x.points_won for x in t.urls]

    return query, region_id, len(t.urls[0].matches), scores, games_won, points_won


def main(*args):
    queries_grouped, toloka_data, sampled_queries, token, any_param, html_file = args
#    with open('images_queries_sample.json') as f:
#        sampled_queries = json.load(f)

    DEBUG = os.uname()[0] == 'Darwin'
    SHOW_SALIENCY = False
    SEED = 30
    random.seed(SEED)
    np.random.seed(SEED)
    np.set_printoptions(linewidth=240)
    np.set_printoptions(threshold=np.inf)

    html = ''
    with open('static_header.html') as f:
        html_header = f.read()

    toloka_agg, max_rounds = aggregate_toloka_data(toloka_data)

    # выбранные запросы
    if any_param:
        add_random = False
    else:
        add_random = True
    html_queries, sampled_queries_list = get_html_queries(sampled_queries, toloka_agg, queries_divider=30, add_random=add_random)
    html += html_queries

    # =============== отдельные турниры по каждому запросу ===============
    html += '<div class="results">\n'
    metrics = defaultdict(dict)

    processes = multiprocessing.cpu_count() - 1 or 1
    print 'processes {}'.format(processes)
    pool = Pool(processes=processes)

    fn = functools.partial(calc_query_metrics, toloka_agg=toloka_agg, sampled_queries_list=sampled_queries_list)
    results = map(fn, queries_grouped)

    result = []
    # return query, region_id, len(scores), scores, games_won, points_won
    for query, region_id, rounds, scores, games_won, points_won in results:
        result.append({
            'query': query,
            'region_id': region_id,
            'rounds': rounds,
            'games_won': games_won,
            'points_won': points_won,
            'scores': scores,
        })

    return result
