#!/usr/bin/env python
# coding: utf-8

import sys
import json
import types
import argparse


def main(argv):
    parser = argparse.ArgumentParser()
    parser.add_argument('--in1', nargs='*', default=[])
    parser.add_argument('--in2', nargs='*', default=[])
    parser.add_argument('--in3', nargs='*', default=[])
    parser.add_argument('--processed_data')
    parser.add_argument('--html_report')
    parser.add_argument('--code')
    parser.add_argument('--token')
    parser.add_argument('--any_param')
    args = parser.parse_args(argv[1:])

    with open(args.code) as f:
        code = f.read()

    in1 = []
    for filename in args.in1:
        with open(filename) as f:
            data = json.load(f)
            in1 += data if isinstance(data, list) else [data]

    in2 = []
    for filename in args.in2:
        with open(filename) as f:
            data = json.load(f)
            in2 += data if isinstance(data, list) else [data]

    in3 = []
    for filename in args.in3:
        with open(filename) as f:
            data = json.load(f)
            in3 += data if isinstance(data, list) else [data]

    namespace = globals()
    exec(code, namespace)

    html_file = None
    if args.html_report:
        html_file = open(args.html_report, 'w')

    processed_data = namespace['main'](
        in1, in2, in3, args.token, args.any_param, html_file
    )

    if args.processed_data and processed_data is not None:
        with open(args.processed_data, 'w') as output_file:
            if isinstance(processed_data, types.GeneratorType):
                processed_data = list(processed_data)

            json_string = json.dumps(
                processed_data, ensure_ascii=False, indent=4
            ).encode('utf8')
            output_file.write(json_string)

    if args.html_report:
        html_file.close()

if __name__ == '__main__':
    main(sys.argv)
