#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import urllib
import subprocess
from pprint import pprint
from argparse import ArgumentParser

import sys
reload(sys)
sys.setdefaultencoding("utf-8")


def parse_args():
    parser = ArgumentParser(description='')
    parser.add_argument('--packs', nargs='+', dest='packs', required=True)
    # formulas_files
    parser.add_argument('--ranking_models', dest='ranking_models_archive', required=True)
    parser.add_argument('--l2_archive_path', dest='l2_archive_path', required=True)
    parser.add_argument('--l3_archive_path', dest='l3_archive_path', required=True)
    parser.add_argument('--l2_archive_url', dest='l2_archive_url', required=True)
    parser.add_argument('--l3_archive_url', dest='l3_archive_url', required=True)
    parser.add_argument('--formulas_info', dest='formulas_info_path', required=True)
    parser.add_argument('--meta_info', dest='meta_info_path', required=True)
    return parser.parse_args()


def get_info(formula_id):
    response = urllib.urlopen('https://fml.yandex-team.ru/rest/api/formula/fml/' + formula_id)
    return json.loads(response.read())


def get_pool_id(formula_path):
    res = subprocess.check_output("./mx_ops info {formula_path} | grep 'pool-id'".format(formula_path=formula_path), shell=True)
    # keep only digits for pool_id
    return ''.join(c for c in res if c.isdigit())

def download_formula(formula_id, formula_path):
    fml_url = 'https://fml.yandex-team.ru/download/computed/formula?id={formula_id}&file=matrixnet.info'.format(formula_id=formula_id)
    urllib.urlretrieve(fml_url, formula_path)


def formulas_join(t1, t2, column):
    result = []
    for entry in t1:
        for match in [d for d in t2 if d[column] == entry[column]]:
            result.append((entry, match))
    return result


def get_stats(packs):
    max_description_length = max([len(x['title']) for x in packs])
    stats =  '{title:{padding}}  :   L1  /   L2  /  L3   /\n'.format(title='formula', padding=max_description_length)
    for item in packs:
        stats += '{title:{padding}}  : {l1}, {l2}, {l3}\n'.format(
            title=item['title'],
            l1=item['l1'],
            l2=item['l2'],
            l3=item['l3'],
            padding=max_description_length
        )
    stats += '\n\n\n\n'
    for item in packs:
        cgi = ''
        testid = {'IMAGES_ALL': {'pron': []}}
        if 'l1' in item:
            param = 'exp_imagesformula_full.panther.l1_{}'.format(item['l1'])
            cgi += '&pron=' + param
            testid['IMAGES_ALL']['pron'].append(param)
        if 'l2' in item:
            param = 'exp_imagesformula_full.fast.common_{}'.format(item['l2'])
            cgi += '&pron=' + param
            testid['IMAGES_ALL']['pron'].append(param)

            param = 'exp_imagesformula_full.fast.common.noboost_{}'.format(item['l2'])
            cgi += '&pron=' + param
            testid['IMAGES_ALL']['pron'].append(param)
        if 'l3' in item:
            param = 'exp_imagesformula_full.common_{}'.format(item['l3'])
            cgi += '&pron=' + param
            testid['IMAGES_ALL']['pron'].append(param)

            param = 'exp_imagesformula_full.common.noboost_{}'.format(item['l3'])
            cgi += '&pron=' + param
            testid['IMAGES_ALL']['pron'].append(param)
        stats += '{title}\n{cgi}\n{testid}\n\n'.format(
            title=item['title'],
            cgi=cgi,
            testid=json.dumps(testid)
        )
        item['cgi'] = cgi
    return stats


def create_formulas_archives(packs, l2_archive_path, l3_archive_path):
    result = []
    for pack in packs:
        for formula_level in ['l1', 'l2', 'l3']:
            if formula_level in pack:
                formula_id = pack[formula_level]
                formula_path = './models/{level}/prod/ExpFormula{formula_id}.info'.format(
                    formula_id=formula_id,
                    level='l2' if formula_level == 'l1' else formula_level
                )
                print 'Download {fml} to {path}'.format(fml=formula_id, path=formula_path)
                download_formula(formula_id, formula_path)
                #info = get_info(formula_id)

    for formula_level in ['l2', 'l3']:
        # create archives with exp formulas
        subprocess.call('./archiver -q -r -p -o {out} ./models/{formula_level}/prod/*.info'.format(
            out=locals()[formula_level + '_archive_path'],
            formula_level=formula_level
        ), shell=True)

    print subprocess.call('svn st models', shell=True)


def main():
    args = parse_args()
    print args

    # extract archive with svn folder ranking_models
    subprocess.call('mkdir -p models', shell=True)
    subprocess.call('tar xf {arch} -C models'.format(arch=args.ranking_models_archive), shell=True)

    packs = []
    for pack_path in args.packs:
        with open(pack_path) as f:
            packs.append(json.load(f))

    create_formulas_archives(packs, args.l2_archive_path, args.l3_archive_path)

    with open(args.formulas_info_path, 'w') as output_file:
        output_file.write(get_stats(packs))

    with open(args.meta_info_path, 'w') as output_file:
        json_string = json.dumps({
            'all_formulas': packs,
            'l2_archive_url': args.l2_archive_url,
            'l3_archive_url': args.l3_archive_url,
        }, ensure_ascii=False, indent=4, sort_keys=True).encode('utf8')
        output_file.write(json_string)


if __name__ == '__main__':
    main()
