#!/bin/bash

L2_FORMULAS=$1
L3_FORMULAS=$2
RANKING_MODELS_ARCHIVE=$3
OUTPUT_L2_ARCH=$4
OUTPUT_L3_ARCH=$5
OUTPUT_INFO=$6

TEMP_FILENAME="formulas.tmp.txt"
echo -n '' > $TEMP_FILENAME

tar xzf $RANKING_MODELS_ARCHIVE

i=0
for formula in $L2_FORMULAS; do
    ((i++))
    formula_id=`./jq -r '.id' $formula`
    formula_title=`curl "https://fml.yandex-team.ru/rest/api/formula/fml/$formula_id" 2>/dev/null | ./jq -r '.description'`
    formula_info="l2/prod/ExpFormula_$formula_id.info"
    echo "download formula $formula_id to $formula_info"
    curl -o $formula_info "https://fml.yandex-team.ru/download/computed/formula?id=$formula_id&file=matrixnet.info" 2>/dev/null
    pool_id=`./mx_ops info $formula_info | grep 'pool-id' | awk '{print $2}'`
    echo "#$i l2 formula: $formula $formula_id $formula_title, pool: $pool_id"
    echo -e "$pool_id\tl2\t$formula_id\t$formula_title\t" >> $TEMP_FILENAME
done
./archiver -q -r -p -o $OUTPUT_L2_ARCH ./l2/prod/*.info

i=0
for formula in $L3_FORMULAS; do
    ((i++))
    formula_id=`./jq -r '.id' $formula`
    formula_title=`curl "https://fml.yandex-team.ru/rest/api/formula/fml/$formula_id" 2>/dev/null | ./jq -r '.description'`
    formula_info="l3/prod/ExpFormula$formula_id.info"
    echo "download formula $formula_id to $formula_info"
    curl -o $formula_info "https://fml.yandex-team.ru/download/computed/formula?id=$formula_id&file=matrixnet.info" 2>/dev/null
    pool_id=`./mx_ops info $formula_info | grep 'pool-id' | awk '{print $2}'`
    echo "#$i l3 formula: $formula $formula_id $formula_title, pool: $pool_id"
    echo -e "$pool_id\tl3\t$formula_id\t$formula_title\t" >> $TEMP_FILENAME
done
./archiver -q -r -p -o $OUTPUT_L3_ARCH ./l3/prod/*.info

echo "\nall files:"
svn status

printf "%-20s :   L2   /  L3   / pool / serpset / cgi-params\n" "formula" > $OUTPUT_INFO
cat $TEMP_FILENAME | sort | sed '$!N;s/\n/ /' | awk -F $'\t' '{ printf "%-20s : %s, %s, %s, -, &pron=exp_imagesformula_full.fast.common_%s&pron=exp_imagesformula_full.fast.common.noboost_%s&pron=exp_imagesformula_full.common_%s&pron=exp_imagesformula_full.common.noboost_%s\n", $4, $3, $7, $1, $3, $3, $7, $7 }' >> $OUTPUT_INFO
echo -e "\n\n\nmetrics's scraper param:" >> $OUTPUT_INFO
cat $TEMP_FILENAME | sort | sed '$!N;s/\n/ /' | awk -F $'\t' '{ printf "&pron=exp_imagesformula_full.fast.common_%s&pron=exp_imagesformula_full.fast.common.noboost_%s&pron=exp_imagesformula_full.common_%s&pron=exp_imagesformula_full.common.noboost_%s#", $3, $3, $7, $7 }' >> $OUTPUT_INFO
rm $TEMP_FILENAME
