import functools
import json
import yaml

import job_context
import mr_job_context
from .util import byteify


def nirvana_operation(result=None, dumper=None):
    def wrapper(func):
        @functools.wraps(func)
        def wrapped():
            ctx = job_context.context()
            inputs = ctx.get_inputs()
            outputs = ctx.get_outputs()
            params = ctx.get_parameters()
            if result:
                assert outputs.has(result), 'result %s not in outputs' % result
            rv = func(ctx, inputs, outputs, byteify(params))
            if result:
                with open(outputs.get(result), 'w') as out:
                    if dumper == 'json':
                        json.dump(rv, out)
                    elif dumper == 'yaml':
                        yaml.dump(rv, out)
                    else:
                        out.write(str(rv))
        return wrapped
    return wrapper


def nirvana_mr_operation():
    def wrapper(func):
        @functools.wraps(func)
        def wrapped():
            ctx = mr_job_context.context()
            inputs = ctx.get_inputs()
            outputs = ctx.get_outputs()
            params = ctx.get_parameters()
            mr_inputs = ctx.get_mr_inputs()
            mr_outputs = ctx.get_mr_outputs()
            func(ctx, inputs, mr_inputs, outputs, mr_outputs, byteify(params))
        return wrapped
    return wrapper
