#!/usr/bin/env python
# coding: utf-8

import json
import argparse

import sys
reload(sys)
sys.setdefaultencoding("utf-8")


def main(argv):
    parser = argparse.ArgumentParser()
    parser.add_argument('--l1')
    parser.add_argument('--l2')
    parser.add_argument('--l3')
    parser.add_argument('--l1_id')
    parser.add_argument('--l2_id')
    parser.add_argument('--l3_id')
    parser.add_argument('--config', required=True)
    parser.add_argument('--title')
    args = parser.parse_args(argv[1:])

    result = {
        'title': (args.title or 'images formula'),
    }

    if args.l1:
        with open(args.l1) as f:
            result['l1'] = json.load(f)['id']
    if args.l2:
        with open(args.l2) as f:
            result['l2'] = json.load(f)['id']
    if args.l3:
        with open(args.l3) as f:
            result['l3'] = json.load(f)['id']

    if args.l1_id:
        result['l1'] = args.l1_id
    if args.l2_id:
        result['l2'] = args.l2_id
    if args.l3_id:
        result['l3'] = args.l3_id

    with open(args.config, 'w') as output_file:
        json_string = json.dumps(result, ensure_ascii=False, indent=4).encode('utf8')
        output_file.write(json_string)

if __name__ == '__main__':
    main(sys.argv)
