#!/usr/bin/python
# -*- coding: utf-8 -*-

import json
import urllib
import subprocess
from pprint import pprint
from argparse import ArgumentParser

from sdms_api import SdmsApi
import nirvana.job_context as nv


def parse_args():
    parser = ArgumentParser(description='')
    parser.add_argument('--meta_info', dest='meta_info_path', required=True)
    parser.add_argument('--sdms_beta', dest='sdms_beta', required=True)
    parser.add_argument('--force_run_beta', dest='force_run_beta', action='store_true')
    parser.add_argument('--sdms_token', dest='sdms_token', required=True)
    parser.add_argument('--mlm_config', dest='mlm_config_path', required=True)
    return parser.parse_args()


def make_mlm_config(all_formulas, sdms_beta):
    config = {
        'responsibleUsers': ['nerevar'],
        'name': 'Images Experimental Formulas Evaluation',
        'description': 'Конвеер в нирване для снятия серпов с беты для формул ранжирования Картинок',
        'priority': 20,
        'launchTemplates': [{
            'regional': 'RU',
            'evaluation': 'IMAGES',
            'name': 'RU-default',
            #'description': None,
            'acceptanceTestFactories': [],
            'servers': [],
            'queryGroups': [
                {
                    'externalId': '12151',
                    'name': 'images_ru_validate',
                    'filters': [],
                    'metrics': [
                        {
                            "externalId": "judged-images-p10",
                            "name": "judged-images-p10",
                            "enrichment": False,
                        },
                        {
                            "externalId": "judged-images-normalized-p10",
                            "name": "judged-images-normalized-p10",
                            "enrichment": False,
                        },
                        {
                            "externalId": "judged10",
                            "name": "judged10",
                            "enrichment": False,
                        },
                        {
                            "externalId": "mimca-mds-url-judged-10",
                            "name": "mimca-mds-url-judged-10",
                            "enrichment": False,
                        },
                    ]
                }
            ]
        }]
    }

    for item in all_formulas:
        server_config = {
            'name': item['title'],
            'cgi': 'no-tests=1&srcask=IMAGES&nocache=da&rearr=ImgQueryUrlBan_off&rearr=ShortBeak_off&relev=porn_rnd_perm_weight=0&relev=disable_query_url_ban&rwr=-ImgPatch',
            'host': '{}.hamster.yandex.ru'.format(sdms_beta),
            'baseline': 'noboost' in item['title'],
            'config': {
                'description': item['title'],
                'numdoc': 30,
                'waitall': True,
                'priority': 20,
                'profileId': 'weak_consistency__image__desktop__c1',
                'useScraper': True,
                'threadCount': 4,
                'connectionsCount': 5,
                'quota': 'mm-research',
                'checkBetaValidation': True
            }
        }
        server_config['cgi'] += item['cgi']
        config['launchTemplates'][0]['servers'].append(server_config)

    return config


def start_sdms_beta(l2_archive_url, l3_archive_url, nirvana_url, sdms_beta, force_run_beta, sdms_token):
    api = SdmsApi('https://sdms.yandex-team.ru', ssl_verify=False, token=sdms_token)
    print 'Sdms beta: {}'.format(sdms_beta)
    if api.beta_exists(sdms_beta):
        info = api.get_beta_info(sdms_beta)
        print info
        print 'Beta status: {}'.format(info['state']['status'])
        if force_run_beta or info['state']['status'] in ['CONSISTENT', 'STOPPED', 'STOPPPED']:
            print 'Starting beta...'
            data = {
                'config': {
                    'img-vm-main:IMG_BASE': {'resources': {'models.archive': l2_archive_url}},
                    'img-mmeta:IMG_MMETA': {'resources': {'models.archive': l3_archive_url}},
                },
                'start': True,
                'message': 'Run images formulas evaluation from nirvana: {}'.format(nirvana_url),
                'mode': 'APPEND'
            }
            api.update_beta(sdms_beta, data)


def main():
    args = parse_args()
    print args

    ctx = nv.context()
    workflow_url = ctx.get_meta().get_workflow_url()

    with open(args.meta_info_path) as f:
        info = json.load(f)

    start_sdms_beta(info['l2_archive_url'], info['l3_archive_url'], workflow_url, args.sdms_beta, args.force_run_beta, args.sdms_token)

    mlm_config = make_mlm_config(info['all_formulas'], args.sdms_beta)

    with open(args.mlm_config_path, 'w') as f:
        f.write(json.dumps(mlm_config, indent=4).decode('unicode-escape').encode('utf8'))


if __name__ == '__main__':
    main()

