# Описание

Запуск тестов на метрики и процессы аналитики.  
```run_tests.py``` запускает внутренние тесты, лежащие в internal_test. Результаты складываются на YT.  
```run_checks.py``` запускает проверку посчитанных тестов на корректность и соответствие правилам-чекерам. На выходе есть табличка в html, которую можно отправить на рассылку.  
Данные скрипты запускаются автоматически ежедневно.
### Как написать свой тест
1. Идем в ```internal_test``` и создаем новый json-конфиг со следующими полями:
* ```id``` - уникальное имя теста, должно совпадать с именем файла (с точностью до расширения json).
* ```type``` –  тип сервиса, на который работает тест. Например, metrics.
* ```subtype``` – тип теста в рамках сервиса.
* ```name``` – название, которое будет отображаться в email очете.
* ```responsible``` – список логинов ответственных.
* ```params``` – параметры, которые будут переданы в тест-функцию. Если параметры не требуются, оставить ```{}```.
* ```links``` – сюда можно захардкодить ссылки на процессы или графики, которые будут отправляться в отчет. Массив словариков, в каждом из которых должно быть поле **url** и **name**. Если ссылки не требуются, поле можно пропустить.
* ```link_generator``` – автоматический генератор ссылок. **type** – название генератора, **params** – список параметров для функии.
* ```checker``` – параметры чекера, который будут проверять корректность результатов теста.  
**freshness** – сколько дней результат теста считается актуальным.  
**type** – название чекера.  
**params** – параметры, которые будут переданы в чекер-функцию. Если параметры не требуются, оставить ```{}```
2. Пишем свой тест в ```tests.py```
Функция должна принимать на вход словарь **tokens** в котором будут все необходимые токены сервисов, остальные параметры опциональны. Все, что указано в конфиге в **params**. В случае ошибки должна возвращать строку **ERROR**. В случае успеха можно возвращать что угодно, что будет пониматься чекером. Созданную функцию также надо прописать в переменную **test_functions** по структурой вложенности **type -> subtype** из конфига.
3. Пишем свой тест в ```checkers.py```
Функция должна принимать на вход тот статус, который выдает тест из ```tests.py``` и возвращать **True / False**. Проверку на время обновления данных теста тут делать не нужно, она происходит автоматически. Чекер надо прописать в переменную ```checkers``` по пути **checker -> type** из конфига.
4. Пишем генератор ссылок в ```links.py```.
Функция должна принимать на вход обязательный параметр **test**, а также все параметры из генератора, который указан в конфиге в **link_generator -> type**. Новую функцию надо добавить в словарик **link_functions**.
