import datetime

def check_ok(status):
    return status.lower() == 'ok'


def check_string_status(status, target):
    return status == target


def check_interval(status, lower, upper):
    val = float(status)
    return val >= lower and val <= upper


def check_ts_age_ms(status, max_age_days):
    ts_ms = int(status)
    test_time = datetime.datetime.utcfromtimestamp(ts_ms / 1000)
    cur_time = datetime.datetime.now()
    time_delta = cur_time - test_time

    return time_delta.days < max_age_days


def check_interval_for_array(status, intervals):
    if len(status) != len(intervals):
        return False
    for num, interval_dict in zip(status, intervals):
        if num < interval_dict.get('min', -1) or num > interval_dict.get('max', 0):
            return False
    return True

############# MAPPING ###############

checkers = {
    'check_ok': check_ok,
    'check_interval': check_interval,
    'check_string_status': check_string_status,
    'check_ts_age_ms': check_ts_age_ms,
    'check_interval_for_array': check_interval_for_array
}
