import os

def link_metrics_cron(test):
    template = 'https://metrics.yandex-team.ru/graphs/chart?crons={cron}&metrics={metric}&lines={cron},{host},{filt},{metric}'
    url = template.format(
        metric=test['params']['metric_name'],
        cron=test['params']['cron_id'],
        host=test['params']['host_id'],
        filt=test['params']['filt']
    )
    return [(url, 'metrics')]


def link_stat_toloka_tree(test, requester_id):
    template = 'https://stat.yandex-team.ru/{project}/{path}?scale={scale}&max_distance=1&_incl_fields={field_name}&tree_field__mode=leaf&view=Dynamics&tree_field={tree_path}&_period_distance=14'
    node_id = test['params']['node_id']
    tree_path = '%09'.join(['', 'All', requester_id, node_id, ''])
    url = template.format(
        project=test['params']['project'],
        path=test['params']['path'],
        scale=test['params']['cgi']['scale'],
        field_name=test['params']['field_name'],
        tree_path=tree_path
    )
    return [(url, 'stat')]


def link_nirvana_workflow(test, workflow):
    if workflow is None:
        return []
    url = os.path.join('https://nirvana.yandex-team.ru/flow', workflow)
    return [(url, 'nirvana')]


def link_metrics_basket(test):
    url = 'https://metrics.yandex-team.ru/baskets/{}/queries'.format(test['params']['basket_id'])
    return [(url, 'metrics')]


def link_hitman_process(test, process_code):
    url = 'https://hitman.yandex-team.ru/r/processes/{}'.format(process_code)
    return [(url, 'hitman')]


def link_yt_path(test, yt_path, cluster='hahn'):
    url = 'https://yt.yandex-team.ru/{}/navigation?path={}'.format(cluster, yt_path)
    return [(url, 'yt')]


################# MAPPING ##################3

link_functions = {
    'metrics_cron': link_metrics_cron,
    'stat_toloka_tree': link_stat_toloka_tree,
    'nirvana_workflow': link_nirvana_workflow,
    'metrics_basket': link_metrics_basket,
    'hitman_process': link_hitman_process,
    'yt_path': link_yt_path
}
