import yt.wrapper as yt
import json
import sys
import codecs
import logging
from checkers import checkers
from utils import apply_check, create_html_result
import argparse


def main():
    parser = argparse.ArgumentParser(description='Run internal tests')
    parser.add_argument('--out-json', required=True)
    parser.add_argument('--out-html', required=True)
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--yt-path', required=True)
    args = parser.parse_args()

    yt.update_config({"proxy": {"url": "hahn.yt.yandex.net"}, "token": args.yt_token})

    test_names = yt.list(args.yt_path)

    logging.basicConfig(
        level=logging.INFO,
        format='%(asctime)s - [%(levelname)s] - %(message)s'
    )

    results = []

    for name in test_names:
        path = '{}/{}'.format(args.yt_path, name)
        for test_result in list(yt.read_table(path)):
            try:
                logging.info("Running check {}".format(test_result['test']['id']))
                apply_check(test_result, checkers, path)
                logging.info("Got status {}\n".format(test_result['check_status']))
                results.append(test_result)
            except Exception as e:
                logging.error("Check exception {}\n".format(str(e)))

    with codecs.open(args.out_html, 'w', 'utf8') as f:
        f.write(create_html_result(results))

    with codecs.open(args.out_json, 'w', 'utf8') as f:
        json.dump(results, f, ensure_ascii=False)


if __name__ == '__main__':
    main()
