def page_domains_regionality(data, regional_domains, basket_domains, language_to_domain, page_region_source='url', use_query_lang=True, check_common=True):
    for elem in data:
        query_domain = elem['query_country']
        query_lang = elem.get('language', '')
        query_lang_domain = language_to_domain.get(query_lang, query_lang)

        page_domain = elem['component_page_url'].split('/')[2].split('.')[-1].upper()
        if page_region_source == 'url':
            page_lang_domain = page_domain
        elif page_region_source == 'title':
            page_lang = elem['title_language']
            page_lang_domain = language_to_domain.get(page_lang, page_lang)
        else:
            raise Exception("Unknown page_region_source: {}",format(page_region_source))

        if check_common and page_lang_domain not in regional_domains and page_lang_domain not in ['UK', 'UNDEFINED']:
            match = 'COMMON_DOMAIN'
        elif page_lang_domain == query_domain:
            match = 'MATCH_QUERY_DOMAIN'
        elif use_query_lang and query_lang_domain != '' and page_lang_domain == query_lang_domain:
            match = 'MATCH_QUERY_LANG'
        elif page_lang_domain == 'RU':
            match = 'NOT_MATCH_WIDE'
        elif page_lang_domain == 'UNDEFINED':
            match = 'NOT_MATCH_OTHER'
        elif page_lang_domain == 'UK':
            match = 'NOT_MATCH_EN'
        elif page_lang_domain in basket_domains:
            match = 'NOT_MATCH_NARROW_BASKET'
        else:
            match = 'NOT_MATCH_NARROW_NOT_BASKET'

        elem['match'] = match

    return data
