import hashlib

def parse_scraper_serp_with_docids(data):
    results = []
    for serp in data:
        if 'serp-page' not in serp:
            continue
        if serp['serp-page'] is None or 'parser-results' not in serp['serp-page']:
            continue
        if serp['serp-page']['parser-results'] is None or 'components' not in serp['serp-page']['parser-results']:
            continue

        for component in serp['serp-page']['parser-results']['components']:
            if component['type'] != 'SEARCH_RESULT':
                continue
            if 'serp-component-debug-dump' not in component:
                continue
            if not isinstance(component['serp-component-debug-dump'], dict):
                continue
            if 'documentid' not in component['serp-component-debug-dump']:
                continue
            docid = component['serp-component-debug-dump']['documentid']
            m = hashlib.md5()
            m.update(docid.encode('utf-8'))
            img_url = component['image-url']
            results.append({"doc_id" : m.hexdigest(),
                            "image_url" : img_url,
                            "query_text" : serp["serp-request-explained"]["per-query-parameters"]["query-text"],
                            "query_region_id" : serp["serp-request-explained"]["per-query-parameters"]["region-id"],
                            "user_agent_type": serp["serp-request-explained"]["per-query-parameters"]["user-agent-type"]
            })
    return results
