#!/usr/bin/env python
# -*- coding: utf-8 -*-
from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    resources as sr,
    filters as qf
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import json
import datetime

YT_TOKEN = open('/home/anastasiiait/.yt/token', 'r').read().replace('\n', '')
cluster = clusters.Hahn(yql_token=YT_TOKEN,
    yql_token_for={"yt"})
job = cluster.job().env(templates = dict(
    job_root = '//home/images/dev/anastasiiait/TASKS/RESEARCH/audit'
))
paths = set(["/image/new/preview/commercial/related/schemaorg",
             "/image/new/preview/commercial/related/market",
             "/image/new/preview/commercial/title/market",
            "/image/new/preview/commercial/link/market",
            "/image/new/preview/commercial/button/market",
            "/image/new/preview/commercial/thumb/market",
            "/image/touch/preview/commercial/link/market",
            "/image/touch/preview/commercial/button/market",
            "/snippet/images/commercial/related/schemaorg",
            "/snippet/images/commercial/title/market",
            "/snippet/images/commercial/path/market",
            "/snippet/images/commercial/button/market",
            "/snippet/images/commercial/thumb/market",
            "/snippet/images/commercial/related/market"
])


def get_ui(r):
    ui=''
    if r.IsA('TDesktopUIProperties'):
        ui = 'desktop'
    elif r.IsA('TTouchUIProperties') or r.IsA('TMobileAppUIProperties') or r.IsA('TPadUIProperties'):
        ui = 'touch+searchapp+pad'
    return ui

def gather_request_events(request):
    result = []
    if request.IsA('TWebRequestProperties'):
        result.append(request.GetClicks())
    elif request.IsA('TImagesRequestProperties'):
        result.append(request.GetClicks())

        for event in r.GetOwnEvents():
            if event.IsA('TImageShow'):
                result.append(event)
            elif event.IsA('TImageNavig'):
                if "show" in event.ConvertedPath or "rim/more" in event.ConvertedPath: #TODO:уточнить
                    continue
                else:
                    result.append(event)
    return result

@with_hints(output_schema=dict(
    click=int,
    path=str,
    device=str
    )
)
def parse_user_sessions_img(recs):

    for key, records in sessions:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict', None)
        except Exception as e:
            continue

        previos_action_timestamp = None
        last_greenurl_path = None
        previous_action_path = None

        for r in session:
            if previous_action_path in paths and previos_action_timestamp is not None:
                if r.Timestamp > previos_action_timestamp + 120:
                    yield Record(
                        click=1,
                        path=previous_action_path,
                        device=ui
                     )
                    previous_action_path = None
                    previous_action_timestamp = r.Timestamp

            ui = get_ui(r)

            events = gather_request_events(r)

            events.sort(key=lambda x: x.ClientTimestamp)

            for event in events:
                if previos_action_timestamp is not None and previous_action_path in paths and event.Timestamp > previos_action_timestamp + 120:
                     yield Record(
                        click=1,
                        path=previous_action_path,
                        device=ui
                    )

                previous_action_timestamp = event.Timestamp
                previous_action_path = event.ConvertedPath if hasattr(event, 'ConvertedPath') else None


user_sessions = job.table('//user_sessions/pub/sample_by_uid_1p/search/daily/2019-12-07/clean')
image_uids = user_sessions.groupby('key').sort('subkey') \
    .reduce(
        parse_user_sessions_img,
        memory_limit=3*1024,
        files=[
            files.RemoteFile('//statbox/resources/libra.so'),
            files.RemoteFile('//statbox/statbox-dict-last/blockstat.dict')
        ]
    ).put("//home/images/dev/anastasiiait/TASKS/RESEARCH/testingPaths:all")


image_uids.groupby('path') \
    .aggregate(path_clicks=na.sum('click')) \
    .map(add_totals) \
    .groupby('device') \
    .aggregate(sum_clicks = na.sum('path_clicks')\
    .put("//home/images/dev/anastasiiait/TASKS/RESEARCH/testingPaths:aggregated_by_paths")

job.run()

