exports.Task = extend(TolokaHandlebarsTask, function (options) {
    TolokaHandlebarsTask.call(this, options);
}, {
    setSolution: function (solution) {
        TolokaHandlebarsTask.prototype.setSolution.call(this, solution);

        var pane = this.getDOMElement().querySelector('.controls');
        pane.classList.remove('controls_error');

        setTimeout(function () {
            window.taskSuite.switchTasks(+1);
        }, 300);
    }
});

exports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function (options) {
    TolokaHandlebarsTaskSuite.call(this, options);
    window.taskSuite = this;
}, {
    onRender: function () {
        var tasks = this.getTasks();

        this.maxTasks = (tasks !== undefined && tasks && tasks.length) ? tasks.length : 1;

        this._initControls();
    },

    _initControls: function() {
        var _this = this;

        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_total'), function (el) {
            // В каждый таск прописываем кол-во тасков
            el.innerText = _this.maxTasks;
        });

        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_current'), function (el, idx) {
            // В каждый таск устанавливаем его номер
            el.innerText = idx + 1;
        });

        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll('.arrows_arrow'), function (el) {
            // Обработчик клика по стрелкам
            return el.addEventListener('click', _this.onTaskArrows.bind(_this));
        });
    },

    onTaskArrows: function(e) {
        var direction = +e.target.dataset.dir;

        setTimeout(function () {
            window.taskSuite.switchTasks(direction);
        }, 200);
    },

    switchTasks: function (direction) {
        var currentTask = this.getFocusedTask() && parseInt(this.getFocusedTask().getTask().id);
        var nextTask = Math.min(Math.max(currentTask + direction, 0), this.maxTasks - 1);

        this.focusTask(nextTask);
    },

    onValidationFail: function (errors) {
        var tasks = this.getTasksIndexed();

        TolokaHandlebarsTaskSuite.prototype.onValidationFail.apply(this, arguments);

        errors.forEach(function (err) {
            if (err) {
                tasks[err.task_id].getDOMElement().querySelector('.controls').classList.add('controls_error');
            }
        });
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
