module.exports = {
    api: {
        host: 'https://toloka.yandex.com'
    },
    project: {
        id: '15368',
        public_name: 'Оценка визуального качества картинок (V4.0)',
        public_description: 'Задания за 0.02 – 0.03 станут доступны после прохождения обучения и экзамена/реабилитации',
        public_instructions: '<div> <div>Цель задания — оценить качество картинки. </div><div><br /></div><div>Главное <b>отличие от версии V3.0</b> – показывается только одна картинка на странице, оценивать ее нужно в полноэкранном режиме и в показанном размере.</div><div><br /></div><div>Общие правила оценивания:</div><div><ul><li>Просматривайте изображения <b>в полноэкранном режиме</b> на мониторе с диагональю не менее 13 дюймов и разрешением не менее 1280x900 пикселей. Для перехода в полноэкранный режим нажмите кнопку <img src="http://avatars.mds.yandex.net/get-toloka_images/474755/8d2acd8e2234522445fa423/orig" alt="" style="height:20px" /> в правом верхнем углу страницы.<br /></li><li>Качество изображений не связано с их размером. Оценивайте изображения в масштабе по умолчанию (чтобы перейти к нему, нажмите клавиши <b>CTRL &#43; 0</b>).</li></ul><div>На каждой странице отображается одна картинка. Когда Вы ее оцените, откроется следующее изображение. Для навигации по страницам пользуйтесь стрелками.</div></div></div><div><br /></div><br /><b>«Обычное»</b> качество — это картинка без очевидных дефектов и с хорошо различимым содержанием. В эту категорию попадает большинство бытовых любительских фотографий и детских рисунков, которые малоинтересны для посторонних и малопригодны для использования (декоративного, учебного, и т.д.), а также профессиональные фото, иллюстрации, скриншоты, качество которых было заметно снижено в результате чрезмерного сжатия файла, растяжения размеров картинки или добавления не сильно мешающего watermark&#39;a.<br /><b>Примеры картинок обычного качества:</b><br /><table style="width:760px"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/4_QUOTpxt8FO/orig" /></td><td></td></tr></tbody></table><table style="width:695px"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/247178/FgbguhaaGPOC/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/NQCk6dKhfnU0/orig" /></td></tr></tbody></table><table style="width:840px"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/Z1tgzlaAyLcO/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/6ibun2HowtmP/orig" /></td></tr></tbody></table><table style="width:800px"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/wp78XL6ihfvc/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/CrL4p0H_Oenv/orig" /></td></tr></tbody></table><b></b><br />Картинку <b>&#34;отличного&#34;</b> качества отличает то, что она выглядит достаточно профессионально, имеет хорошую резкость и баланс яркости, важные детали хорошо различимы. Эти картинки чаще всего приятны или интересны для просмотра, либо содержат какую-либо визуальную информацию в легко читаемом виде. Следует учесть, что порнографические изображения также в принципе могут иметь отличное визуальное качество. Картинка отличного качества может быть различных типов, вот несколько типичных примеров: <br /> <table style="width:100%"><tbody><tr><td>Хорошо сделанная фотография (цветная или черно-белая), пригодная для печати или для оформления сайта.</td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/iH55_N2WEljq/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/SEdW6bMPPcp7/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td>Иллюстрация (рисунок, открытка, афиша, демотиватор), явно сделанная художником</td><td><img style="height:320px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/0lZQ-HrFY76a/orig" /></td><td><img style="height:320px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/ZK_L2__wRrUL/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td>Качественное изображение товара, полезное для потенциального покупателя</td><td><img style="height:320px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/uRDAnBv5Q50P/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td>Качественное фото или изображение технического, медицинского или учебного содержания, пригодное для изучения какого-либо объекта или процесса;<br />схема, план, карта, скан документа, таблица с хорошо различимыми деталями и надписями</td><td><img style="height:400px" src="http://avatars.mds.yandex.net/get-toloka_images/247178/i_3hxGgFs7Wn/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td>Небольшое изображение хорошего качества, подходящее в качестве иконки или аватарки</td><td><img style="height:100px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/SIPisgy7hrR0/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td>качественный скриншот из компьютерной игры, фильма или мультфильма;</td></tr></tbody></table> <table style="width:100%"><tbody><tr><td><img style="height:260px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/EDm5tycsutIf/orig" /></td><td><img style="height:260px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/hD5RnHIcDIzC/orig" /></td></tr></tbody></table><b><br /></b><div><b>&#34;Плохое&#34;</b> качество — если картинка в большой степени нечёткая (в показанном размере), зашумленная, затемненная, засвеченная, намеренно испорченная (кроме случаев, когда это очевидно художественный приём), содержит большой и заметный watermark, который мешает, содержащая грубые артефакты сжатия. Также сюда относятся картинки слишком маленького размера для их назначения: нечитабельные документы, схемы, карты, таблицы<br /> <b>Примеры картинок плохого качества:</b><br />   <table style="width:100%"><tbody><tr><td></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/vu4YBNhIKske/orig" /></td><td><img style="height:200px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/M7XDynwx_GkP/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/99gsbtqevWyP/orig" /></td><td><img style="height:330px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/VFElZQwuOo3e/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/To1qdHnxATdg/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/201068/ATmOWjMVFC91/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/247178/qRioO6bbF_aE/orig" /></td><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/474755/PitHIZQlW-CZ/orig" /></td></tr></tbody></table> <table style="width:100%"><tbody><tr><td><img style="height:300px" src="http://avatars.mds.yandex.net/get-toloka_images/329199/1l5IZ7dh4fgC/orig" /> </td><td></td></tr></tbody></table>   Удобно использовать для разметки клавиши &#34;1&#34;, &#34;2&#34;, &#34;3&#34; и стрелки, либо можно пользоваться мышкой.<br /><br />  Ваши ответы периодически проверяются системой. Если они слишком часто неверны, Ваш доступ к этому заданию будет заблокирован.  </div>',
        private_comment: '@scrapbrain, @nerevar',
        task_spec: {
            input_spec: {
                options: {
                    type: 'json',
                    hidden: false,
                    required: false
                },
                image_crc: {
                    type: 'string',
                    hidden: false,
                    required: false
                },
                image_mds: {
                    type: 'url',
                    hidden: false,
                    required: true
                },
                image_url: {
                    type: 'url',
                    hidden: false,
                    required: false
                }
            },
            output_spec: {
                result: {
                    type: 'string',
                    hidden: false,
                    required: true
                }
            },
            view_spec: {
                assets: {
                    style_urls: [],
                    script_urls: [
                        '$TOLOKA_ASSETS/js/toloka-handlebars-templates.js'
                    ]
                },
                markup: '<div class="pane">\n    <div class="arrows">\n        <span class="arrows_arrow arrows_left noselect" title="Листать назад" data-dir="-1">&larr;</span>\n        <span class="arrows_current">1</span>/<span class="arrows_total">10</span>\n        <span class="arrows_arrow arrows_right noselect" title="Листать вперёд" data-dir="1">&rarr;</span>\n    </div>\n    Качество картинки:\n    <div class="controls">\n        {{field type="radio" size="L" name="result" validation-show="bottom-center" value="GOOD" label="Отличное" hotkey="1"}}\n        {{field type="radio" size="L" name="result" validation-show="bottom-center" value="OK" label="Среднее" hotkey="2"}}\n        {{field type="radio" size="L" name="result" validation-show="bottom-center" value="BAD" label="Плохое" hotkey="3"}}\n    </div>\n    {{#if options.comment}}\n        <p class="comment">\n            {{options.comment}}\n        </p>\n    {{/if}}\n</div>\n\n<div class="image_wrapper">\n    <img src="{{image_mds}}" class="image" />\n</div>\n',
                script: 'exports.Task = extend(TolokaHandlebarsTask, function (options) {\n    TolokaHandlebarsTask.call(this, options);\n}, {\n    setSolution: function (solution) {\n        TolokaHandlebarsTask.prototype.setSolution.call(this, solution);\n\n        var pane = this.getDOMElement().querySelector(\'.controls\');\n        pane.classList.remove(\'controls_error\');\n\n        setTimeout(function () {\n            window.taskSuite.switchTasks(+1);\n        }, 300);\n    }\n});\n\nexports.TaskSuite = extend(TolokaHandlebarsTaskSuite, function (options) {\n    TolokaHandlebarsTaskSuite.call(this, options);\n    window.taskSuite = this;\n}, {\n    onRender: function () {\n        var tasks = this.getTasks();\n\n        this.maxTasks = (tasks !== undefined && tasks && tasks.length) ? tasks.length : 1;\n\n        this._initControls();\n    },\n\n    _initControls: function() {\n        var _this = this;\n\n        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll(\'.arrows_total\'), function (el) {\n            // В каждый таск прописываем кол-во тасков\n            el.innerText = _this.maxTasks;\n        });\n\n        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll(\'.arrows_current\'), function (el, idx) {\n            // В каждый таск устанавливаем его номер\n            el.innerText = idx + 1;\n        });\n\n        Array.prototype.forEach.call(this.getDOMElement().querySelectorAll(\'.arrows_arrow\'), function (el) {\n            // Обработчик клика по стрелкам\n            return el.addEventListener(\'click\', _this.onTaskArrows.bind(_this));\n        });\n    },\n\n    onTaskArrows: function(e) {\n        var direction = +e.target.dataset.dir;\n\n        setTimeout(function () {\n            window.taskSuite.switchTasks(direction);\n        }, 200);\n    },\n\n    switchTasks: function (direction) {\n        var currentTask = this.getFocusedTask() && parseInt(this.getFocusedTask().getTask().id);\n        var nextTask = Math.min(Math.max(currentTask + direction, 0), this.maxTasks - 1);\n\n        this.focusTask(nextTask);\n    },\n\n    onValidationFail: function (errors) {\n        var tasks = this.getTasksIndexed();\n\n        TolokaHandlebarsTaskSuite.prototype.onValidationFail.apply(this, arguments);\n\n        errors.forEach(function (err) {\n            if (err) {\n                tasks[err.task_id].getDOMElement().querySelector(\'.controls\').classList.add(\'controls_error\');\n            }\n        });\n    }\n});\n\nfunction extend(ParentClass, constructorFunction, prototypeHash) {\n    constructorFunction = constructorFunction || function () {};\n    prototypeHash = prototypeHash || {};\n    if (ParentClass) {\n        constructorFunction.prototype = Object.create(ParentClass.prototype);\n    }\n    for (var i in prototypeHash) {\n        constructorFunction.prototype[i] = prototypeHash[i];\n    }\n    return constructorFunction;\n}\n',
                styles: '.task-suite {\n    height: 100%;\n    margin: 0;\n    padding: 0;\n}\n\n.task {\n    display: none;\n}\n\n.task_focused {\n    display: block;\n    height: 100%;\n    padding: 0;\n    margin: 0;\n    box-shadow: none;\n}\n\n.pane {\n    width: 100%;\n    height: 40px;\n\n    padding: 0 10px;\n    z-index: 23;\n    background-color: rgba(255, 255, 255, 0.75);\n  \n    overflow: hidden;\n    box-sizing: border-box;\n}\n\n.arrows {\n    display: inline-block;\n    margin: 0 30px 0 0;\n\n    font-size: 20px;\n    line-height: 39px;\n}\n\n.arrows_arrow {\n    cursor: pointer;\n}\n\n.arrows_current {\n    text-align: right;\n    display: inline-block;\n    width: 22px;\n\n}\n.arrows_total {\n    display: inline-block;\n    width: 22px;\n}\n\n\n.controls {\n    display: inline-block;\n    vertical-align: middle;\n    height: 40px;\n}\n\n.controls_error {\n    background-color: rgba(255, 164, 164, 0.85);\n}\n\n.comment {\n    margin: 0 0 0 30px;\n    height: 40px;\n    line-height: 40px;\n    display: inline-block;\n}\n\n.image_wrapper {\n    position: absolute;\n    top: 42px;\n    right: 0;\n    bottom: 0;\n    left: 0;\n\n    text-align: center;\n}\n.image {\n    max-width: 100%;\n    max-height: 100%;\n  \n    /*background-size: 100% auto;*/\n\n    position:absolute;\n    top: 0;\n    bottom: 0;\n    right: 0;\n    left: 0;\n    margin:auto;\n}\n\n.noselect {\n    -webkit-touch-callout: none; /* iOS Safari */\n    /*-webkit-min-device-pixel-ratio: 2; */\n    -webkit-user-select: none; /* Safari */\n    -khtml-user-select: none; /* Konqueror HTML */\n    -moz-user-select: none; /* Firefox */\n    -ms-user-select: none; /* Internet Explorer/Edge */\n    user-select: none; /* Non-prefixed version, currently\n                                  supported by Chrome and Opera */\n}\n',
                settings: {
                    showSkip: true,
                    showTimer: true,
                    showTitle: true,
                    showFinish: true,
                    showReward: true,
                    showSubmit: true,
                    showMessage: true,
                    showFullscreen: true,
                    showInstructions: true
                }
            }
        },
        assignments_issuing_type: 'AUTOMATED',
        assignments_automerge_enabled: false,
        owner: {
            id: '2530a54dc39a16996f6960b14e8f14d4',
            myself: true,
            company_id: '1'
        },
        status: 'ACTIVE',
        created: '2018-09-15T23:08:05.618'
    }
};
